/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.FileInputResource;
import htsjdk.samtools.InputResource;
import htsjdk.samtools.InputStreamInputResource;
import htsjdk.samtools.SRAInputResource;
import htsjdk.samtools.SeekableStreamInputResource;
import htsjdk.samtools.UrlInputResource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class SamInputResource {
    private final InputResource source;
    private InputResource index;

    SamInputResource(InputResource inputResource) {
        this(inputResource, null);
    }

    SamInputResource(InputResource inputResource, InputResource inputResource2) {
        if (inputResource == null) {
            throw new NullPointerException("source");
        }
        this.source = inputResource;
        this.index = inputResource2;
    }

    InputResource data() {
        return this.source;
    }

    InputResource indexMaybe() {
        return this.index;
    }

    public String toString() {
        return String.format("data=%s;index=%s", this.source, this.index);
    }

    public static SamInputResource of(File file) {
        return new SamInputResource(new FileInputResource(file));
    }

    public static SamInputResource of(InputStream inputStream) {
        return new SamInputResource(new InputStreamInputResource(inputStream));
    }

    public static SamInputResource of(URL uRL) {
        return new SamInputResource(new UrlInputResource(uRL));
    }

    public static SamInputResource of(SeekableStream seekableStream) {
        return new SamInputResource(new SeekableStreamInputResource(seekableStream));
    }

    public static SamInputResource of(SRAAccession sRAAccession) {
        return new SamInputResource(new SRAInputResource(sRAAccession));
    }

    public static SamInputResource of(String string) {
        try {
            URL uRL = new URL(string);
            return SamInputResource.of(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return SamInputResource.of(new File(string));
        }
    }

    public SamInputResource index(File file) {
        this.index = new FileInputResource(file);
        return this;
    }

    public SamInputResource index(InputStream inputStream) {
        this.index = new InputStreamInputResource(inputStream);
        return this;
    }

    public SamInputResource index(URL uRL) {
        this.index = new UrlInputResource(uRL);
        return this;
    }

    public SamInputResource index(SeekableStream seekableStream) {
        this.index = new SeekableStreamInputResource(seekableStream);
        return this;
    }
}

