/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.Closeable;
import java.text.MessageFormat;

public interface SamReader
extends Iterable<SAMRecord>,
Closeable {
    public SAMFileHeader getFileHeader();

    public Type type();

    public String getResourceDescription();

    public boolean hasIndex();

    public Indexing indexing();

    public SAMRecordIterator iterator();

    public SAMRecordIterator query(String var1, int var2, int var3, boolean var4);

    public SAMRecordIterator queryOverlapping(String var1, int var2, int var3);

    public SAMRecordIterator queryContained(String var1, int var2, int var3);

    public SAMRecordIterator query(QueryInterval[] var1, boolean var2);

    public SAMRecordIterator queryOverlapping(QueryInterval[] var1);

    public SAMRecordIterator queryContained(QueryInterval[] var1);

    public SAMRecordIterator queryUnmapped();

    public SAMRecordIterator queryAlignmentStart(String var1, int var2);

    public SAMRecord queryMate(SAMRecord var1);

    public static abstract class ReaderImplementation
    implements PrimitiveSamReader {
        abstract void enableFileSource(SamReader var1, boolean var2);

        abstract void enableIndexCaching(boolean var1);

        abstract void enableIndexMemoryMapping(boolean var1);

        abstract void enableCrcChecking(boolean var1);

        abstract void setSAMRecordFactory(SAMRecordFactory var1);

        abstract void setValidationStringency(ValidationStringency var1);
    }

    public static class AssertingIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord previous = null;
        private SAMRecordComparator comparator = null;

        static AssertingIterator of(CloseableIterator<SAMRecord> closeableIterator) {
            return new AssertingIterator(closeableIterator);
        }

        public AssertingIterator(CloseableIterator<SAMRecord> closeableIterator) {
            this.wrappedIterator = closeableIterator;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            if (sortOrder == null || sortOrder == SAMFileHeader.SortOrder.unsorted) {
                this.comparator = null;
                return this;
            }
            this.comparator = sortOrder.getComparatorInstance();
            return this;
        }

        @Override
        public SAMRecord next() {
            SAMRecord sAMRecord = (SAMRecord)this.wrappedIterator.next();
            if (this.comparator != null) {
                if (this.previous != null && this.comparator.fileOrderCompare(this.previous, sAMRecord) > 0) {
                    throw new IllegalStateException(MessageFormat.format("Records {0} ({1}:{2}) should come after {3} ({4}:{5}) when sorting with {6}", this.previous.getReadName(), this.previous.getReferenceName(), this.previous.getAlignmentStart(), sAMRecord.getReadName(), sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart(), this.comparator.getClass().getName()));
                }
                this.previous = sAMRecord;
            }
            return sAMRecord;
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }
    }

    public static class PrimitiveSamReaderToSamReaderAdapter
    implements SamReader,
    Indexing {
        final PrimitiveSamReader p;
        final SamInputResource resource;

        public PrimitiveSamReaderToSamReaderAdapter(PrimitiveSamReader primitiveSamReader, SamInputResource samInputResource) {
            this.p = primitiveSamReader;
            this.resource = samInputResource;
        }

        PrimitiveSamReader underlyingReader() {
            return this.p;
        }

        @Override
        public SAMRecordIterator queryOverlapping(String string, int n, int n2) {
            return this.query(string, n, n2, false);
        }

        @Override
        public SAMRecordIterator queryOverlapping(QueryInterval[] queryIntervalArray) {
            return this.query(queryIntervalArray, false);
        }

        @Override
        public SAMRecordIterator queryContained(String string, int n, int n2) {
            return this.query(string, n, n2, true);
        }

        @Override
        public SAMRecordIterator queryContained(QueryInterval[] queryIntervalArray) {
            return this.query(queryIntervalArray, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAMRecord queryMate(SAMRecord sAMRecord) {
            if (!sAMRecord.getReadPairedFlag()) {
                throw new IllegalArgumentException("queryMate called for unpaired read.");
            }
            if (sAMRecord.getFirstOfPairFlag() == sAMRecord.getSecondOfPairFlag()) {
                throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
            }
            boolean bl = sAMRecord.getFirstOfPairFlag();
            try (SAMRecordIterator sAMRecordIterator = sAMRecord.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(sAMRecord.getMateReferenceName(), sAMRecord.getMateAlignmentStart());){
                SAMRecord sAMRecord2;
                SAMRecord sAMRecord3 = null;
                while (sAMRecordIterator.hasNext()) {
                    sAMRecord2 = (SAMRecord)sAMRecordIterator.next();
                    if (!sAMRecord2.getReadPairedFlag()) {
                        if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) continue;
                        throw new SAMFormatException("Paired and unpaired reads with same name: " + sAMRecord.getReadName());
                    }
                    if ((!bl ? sAMRecord2.getSecondOfPairFlag() : sAMRecord2.getFirstOfPairFlag()) || !sAMRecord.getReadName().equals(sAMRecord2.getReadName())) continue;
                    if (sAMRecord3 != null) {
                        throw new SAMFormatException("Multiple SAMRecord with read name " + sAMRecord.getReadName() + " for " + (bl ? "second" : "first") + " end.");
                    }
                    sAMRecord3 = sAMRecord2;
                }
                sAMRecord2 = sAMRecord3;
                return sAMRecord2;
            }
        }

        @Override
        public boolean hasBrowseableIndex() {
            return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
        }

        @Override
        public BrowseableBAMIndex getBrowseableIndex() {
            BAMIndex bAMIndex = this.getIndex();
            if (!(bAMIndex instanceof BrowseableBAMIndex)) {
                throw new SAMException("Cannot return index: index created by BAM is not browseable.");
            }
            return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(bAMIndex);
        }

        @Override
        public SAMRecordIterator iterator() {
            return new AssertingIterator(this.p.getIterator());
        }

        @Override
        public SAMRecordIterator iterator(SAMFileSpan sAMFileSpan) {
            return new AssertingIterator(this.p.getIterator(sAMFileSpan));
        }

        @Override
        public void close() {
            this.p.close();
        }

        @Override
        public SAMFileSpan getFilePointerSpanningReads() {
            return this.p.getFilePointerSpanningReads();
        }

        @Override
        public SAMFileHeader getFileHeader() {
            return this.p.getFileHeader();
        }

        @Override
        public Type type() {
            return this.p.type();
        }

        @Override
        public String getResourceDescription() {
            return this.resource.toString();
        }

        @Override
        public boolean hasIndex() {
            return this.p.hasIndex();
        }

        @Override
        public Indexing indexing() {
            return this;
        }

        @Override
        public BAMIndex getIndex() {
            return this.p.getIndex();
        }

        @Override
        public SAMRecordIterator query(QueryInterval[] queryIntervalArray, boolean bl) {
            return AssertingIterator.of(this.p.query(queryIntervalArray, bl));
        }

        @Override
        public SAMRecordIterator query(String string, int n, int n2, boolean bl) {
            return this.query(new QueryInterval[]{new QueryInterval(this.getFileHeader().getSequenceIndex(string), n, n2)}, bl);
        }

        @Override
        public SAMRecordIterator queryUnmapped() {
            return AssertingIterator.of(this.p.queryUnmapped());
        }

        @Override
        public SAMRecordIterator queryAlignmentStart(String string, int n) {
            return AssertingIterator.of(this.p.queryAlignmentStart(string, n));
        }
    }

    public static interface PrimitiveSamReader {
        public Type type();

        public boolean hasIndex();

        public BAMIndex getIndex();

        public SAMFileHeader getFileHeader();

        public CloseableIterator<SAMRecord> getIterator();

        public CloseableIterator<SAMRecord> getIterator(SAMFileSpan var1);

        public SAMFileSpan getFilePointerSpanningReads();

        public CloseableIterator<SAMRecord> query(QueryInterval[] var1, boolean var2);

        public CloseableIterator<SAMRecord> queryAlignmentStart(String var1, int var2);

        public CloseableIterator<SAMRecord> queryUnmapped();

        public void close();

        public ValidationStringency getValidationStringency();
    }

    public static interface Indexing {
        public BAMIndex getIndex();

        public boolean hasBrowseableIndex();

        public BrowseableBAMIndex getBrowseableIndex();

        public SAMRecordIterator iterator(SAMFileSpan var1);

        public SAMFileSpan getFilePointerSpanningReads();
    }

    public static abstract class Type {
        public static Type SRA_TYPE = new TypeImpl("SRA", "sra", null);
        public static Type CRAM_TYPE = new TypeImpl("CRAM", "cram", "crai");
        public static Type BAM_TYPE = new TypeImpl("BAM", "bam", "bai");
        public static Type SAM_TYPE = new TypeImpl("SAM", "sam", null);

        abstract String name();

        public abstract String fileExtension();

        abstract String indexExtension();

        static class TypeImpl
        extends Type {
            final String name;
            final String fileExtension;
            final String indexExtension;

            TypeImpl(String string, String string2, String string3) {
                this.name = string;
                this.fileExtension = string2;
                this.indexExtension = string3;
            }

            @Override
            String name() {
                return this.name;
            }

            @Override
            public String fileExtension() {
                return this.fileExtension;
            }

            @Override
            String indexExtension() {
                return this.indexExtension;
            }

            public String toString() {
                return String.format("TypeImpl{name='%s', fileExtension='%s', indexExtension='%s'}", this.name, this.fileExtension, this.indexExtension);
            }
        }
    }
}

