/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.Indexer;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

class StreamInflatingIndexingOutputStream
extends OutputStream {
    private final OutputStream s1;
    private final PipedOutputStream s2;
    private final Thread thread;

    public StreamInflatingIndexingOutputStream(OutputStream outputStream, File file) {
        try {
            this.s1 = outputStream;
            this.s2 = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(this.s2, Defaults.NON_ZERO_BUFFER_SIZE);
            this.thread = new Thread((Runnable)new Indexer(file, pipedInputStream), "BamIndexingThread");
            this.thread.start();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public final void write(int n) throws IOException {
        this.s1.write(n);
        this.s2.write(n);
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.s1.write(byArray);
        this.s2.write(byArray);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.s1.write(byArray, n, n2);
        this.s2.write(byArray, n, n2);
    }

    @Override
    public final void flush() throws IOException {
        this.s1.flush();
        this.s2.flush();
    }

    @Override
    public final void close() throws IOException {
        this.s1.close();
        this.s2.close();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

