/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.util.StringUtil;

public class TextCigarCodec {
    private static final byte ZERO_BYTE = "0".getBytes()[0];
    private static final byte NINE_BYTE = "9".getBytes()[0];

    public static String encode(Cigar cigar) {
        if (cigar.isEmpty()) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            stringBuilder.append(cigarElement.getLength());
            stringBuilder.append((Object)cigarElement.getOperator());
        }
        return stringBuilder.toString();
    }

    public static Cigar decode(String string) {
        if ("*".equals(string)) {
            return new Cigar();
        }
        Cigar cigar = new Cigar();
        byte[] byArray = StringUtil.stringToBytes(string);
        for (int i = 0; i < byArray.length; ++i) {
            if (!TextCigarCodec.isDigit(byArray[i])) {
                throw new IllegalArgumentException("Malformed CIGAR string: " + string);
            }
            int n = byArray[i] - ZERO_BYTE;
            ++i;
            while (TextCigarCodec.isDigit(byArray[i])) {
                n = n * 10 + byArray[i] - ZERO_BYTE;
                ++i;
            }
            CigarOperator cigarOperator = CigarOperator.characterToEnum(byArray[i]);
            cigar.add(new CigarElement(n, cigarOperator));
        }
        return cigar;
    }

    private static boolean isDigit(byte by) {
        return by >= ZERO_BYTE && by <= NINE_BYTE;
    }
}

