/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalCompressor;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    private static final int TAG_VALUE_BUFFER_SIZE = 0x100000;
    public static final int BYTE_SPACE_SIZE = 256;
    public static final int ALL_BYTES_USED = -1;
    private final Map<Integer, EncodingDetails> bestEncodings = new HashMap<Integer, EncodingDetails>();
    private final ByteArrayOutputStream baosForTagValues = new ByteArrayOutputStream(0x100000);

    public CompressionHeader build(List<CramCompressionRecord> list, SubstitutionMatrix substitutionMatrix, boolean bl) {
        CompressionHeaderBuilder compressionHeaderBuilder = new CompressionHeaderBuilder(bl);
        compressionHeaderBuilder.addExternalIntegerRansOrderZeroEncoding(EncodingKey.AP_AlignmentPositionOffset);
        compressionHeaderBuilder.addExternalByteRansOrderOneEncoding(EncodingKey.BA_Base);
        compressionHeaderBuilder.addExternalIntegerRansOrderOneEncoding(EncodingKey.BF_BitFlags);
        compressionHeaderBuilder.addExternalByteGzipEncoding(EncodingKey.BS_BaseSubstitutionCode);
        compressionHeaderBuilder.addExternalIntegerRansOrderOneEncoding(EncodingKey.CF_CompressionBitFlags);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.DL_DeletionLength);
        compressionHeaderBuilder.addExternalByteGzipEncoding(EncodingKey.FC_FeatureCode);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.FN_NumberOfReadFeatures);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.FP_FeaturePosition);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.HC_HardClip);
        compressionHeaderBuilder.addExternalByteArrayStopTabGzipEncoding(EncodingKey.IN_Insertion);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.MF_MateBitFlags);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.MQ_MappingQualityScore);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.NF_RecordsToNextFragment);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.NP_NextFragmentAlignmentStart);
        compressionHeaderBuilder.addExternalIntegerRansOrderOneEncoding(EncodingKey.NS_NextFragmentReferenceSequenceID);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.PD_padding);
        compressionHeaderBuilder.addExternalByteRansOrderOneEncoding(EncodingKey.QS_QualityScore);
        compressionHeaderBuilder.addExternalIntegerRansOrderOneEncoding(EncodingKey.RG_ReadGroup);
        compressionHeaderBuilder.addExternalIntegerRansOrderZeroEncoding(EncodingKey.RI_RefId);
        compressionHeaderBuilder.addExternalIntegerRansOrderOneEncoding(EncodingKey.RL_ReadLength);
        compressionHeaderBuilder.addExternalByteArrayStopTabGzipEncoding(EncodingKey.RN_ReadName);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.RS_RefSkip);
        compressionHeaderBuilder.addExternalByteArrayStopTabGzipEncoding(EncodingKey.SC_SoftClip);
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.TC_TagCount);
        compressionHeaderBuilder.addExternalIntegerEncoding(EncodingKey.TL_TagIdList, ExternalCompressor.createGZIP());
        compressionHeaderBuilder.addExternalIntegerGzipEncoding(EncodingKey.TN_TagNameAndType);
        compressionHeaderBuilder.addExternalIntegerRansOrderOneEncoding(EncodingKey.TS_InsetSize);
        compressionHeaderBuilder.setTagIdDictionary(CompressionHeaderFactory.buildTagIdDictionary(list));
        this.buildTagEncodings(list, compressionHeaderBuilder);
        if (substitutionMatrix == null) {
            substitutionMatrix = new SubstitutionMatrix(CompressionHeaderFactory.buildFrequencies(list));
            CompressionHeaderFactory.updateSubstitutionCodes(list, substitutionMatrix);
        }
        compressionHeaderBuilder.setSubstitutionMatrix(substitutionMatrix);
        return compressionHeaderBuilder.getHeader();
    }

    private void buildTagEncodings(List<CramCompressionRecord> list, CompressionHeaderBuilder compressionHeaderBuilder) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (CramCompressionRecord cramCompressionRecord : list) {
            if (cramCompressionRecord.tags == null || cramCompressionRecord.tags.length == 0) continue;
            for (ReadTag readTag : cramCompressionRecord.tags) {
                hashSet.add(readTag.keyType3BytesAsInt);
            }
        }
        Iterator<CramCompressionRecord> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            if (this.bestEncodings.containsKey(n)) {
                compressionHeaderBuilder.addTagEncoding(n, this.bestEncodings.get(n));
                continue;
            }
            EncodingDetails encodingDetails = this.buildEncodingForTag(list, n);
            compressionHeaderBuilder.addTagEncoding(n, encodingDetails);
            this.bestEncodings.put(n, encodingDetails);
        }
    }

    static void updateSubstitutionCodes(List<CramCompressionRecord> list, SubstitutionMatrix substitutionMatrix) {
        for (CramCompressionRecord cramCompressionRecord : list) {
            if (cramCompressionRecord.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
                Substitution substitution;
                if (readFeature.getOperator() != 88 || (substitution = (Substitution)readFeature).getCode() != -1) continue;
                byte by = substitution.getReferenceBase();
                byte by2 = substitution.getBase();
                substitution.setCode(substitutionMatrix.code(by, by2));
            }
        }
    }

    static long[][] buildFrequencies(List<CramCompressionRecord> list) {
        long[][] lArray = new long[256][256];
        for (CramCompressionRecord cramCompressionRecord : list) {
            if (cramCompressionRecord.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
                if (readFeature.getOperator() != 88) continue;
                Substitution substitution = (Substitution)readFeature;
                byte by = substitution.getReferenceBase();
                byte by2 = substitution.getBase();
                long[] lArray2 = lArray[by];
                byte by3 = by2;
                lArray2[by3] = lArray2[by3] + 1L;
            }
        }
        return lArray;
    }

    private static byte[][][] buildTagIdDictionary(List<CramCompressionRecord> list) {
        Comparator<ReadTag> comparator = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag readTag, ReadTag readTag2) {
                return readTag.keyType3BytesAsInt - readTag2.keyType3BytesAsInt;
            }
        };
        Comparator<byte[]> comparator2 = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                if (byArray.length - byArray2.length != 0) {
                    return byArray.length - byArray2.length;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return byArray[i] - byArray2[i];
                }
                return 0;
            }
        };
        TreeMap<byte[], Object> treeMap = new TreeMap<byte[], Object>(comparator2);
        MutableInt mutableInt = new MutableInt();
        treeMap.put(new byte[0], mutableInt);
        for (CramCompressionRecord cramCompressionRecord : list) {
            if (cramCompressionRecord.tags == null) {
                ++mutableInt.value;
                cramCompressionRecord.tagIdsIndex = mutableInt;
                continue;
            }
            Arrays.sort(cramCompressionRecord.tags, comparator);
            cramCompressionRecord.tagIds = new byte[cramCompressionRecord.tags.length * 3];
            int n = 0;
            for (int i = 0; i < cramCompressionRecord.tags.length; ++i) {
                cramCompressionRecord.tagIds[i * 3] = (byte)cramCompressionRecord.tags[n].keyType3Bytes.charAt(0);
                cramCompressionRecord.tagIds[i * 3 + 1] = (byte)cramCompressionRecord.tags[n].keyType3Bytes.charAt(1);
                cramCompressionRecord.tagIds[i * 3 + 2] = (byte)cramCompressionRecord.tags[n].keyType3Bytes.charAt(2);
                ++n;
            }
            Object object2 = (MutableInt)treeMap.get(cramCompressionRecord.tagIds);
            if (object2 == null) {
                object2 = new MutableInt();
                treeMap.put(cramCompressionRecord.tagIds, object2);
            }
            ++object2.value;
            cramCompressionRecord.tagIdsIndex = object2;
        }
        Object object = new byte[treeMap.size()][][];
        int n = 0;
        for (Object object2 : treeMap.keySet()) {
            int n2 = ((byte[])object2).length / 3;
            object[n] = new byte[n2][];
            int n3 = 0;
            while (n3 < ((byte[])object2).length) {
                int n4 = n3 / 3;
                object[n][n4] = new byte[3];
                object[n][n4][0] = object2[n3++];
                object[n][n4][1] = object2[n3++];
                object[n][n4][2] = object2[n3++];
            }
            ((MutableInt)treeMap.get((Object)object2)).value = n++;
        }
        return object;
    }

    static byte getTagType(int n) {
        return (byte)(n & 0xFF);
    }

    static ExternalCompressor getBestExternalCompressor(byte[] byArray) {
        ExternalCompressor externalCompressor;
        int n;
        ExternalCompressor externalCompressor2;
        int n2;
        ExternalCompressor externalCompressor3 = ExternalCompressor.createGZIP();
        int n3 = externalCompressor3.compress(byArray).length;
        int n4 = Math.min(n3, Math.min(n2 = (externalCompressor2 = ExternalCompressor.createRANS(RANS.ORDER.ZERO)).compress(byArray).length, n = (externalCompressor = ExternalCompressor.createRANS(RANS.ORDER.ONE)).compress(byArray).length));
        if (n4 == n2) {
            return externalCompressor2;
        }
        if (n4 == n) {
            return externalCompressor;
        }
        return externalCompressor3;
    }

    byte[] getDataForTag(List<CramCompressionRecord> list, int n) {
        this.baosForTagValues.reset();
        for (CramCompressionRecord cramCompressionRecord : list) {
            if (cramCompressionRecord.tags == null) continue;
            for (ReadTag readTag : cramCompressionRecord.tags) {
                if (readTag.keyType3BytesAsInt != n) continue;
                byte[] byArray = readTag.getValueAsByteArray();
                try {
                    this.baosForTagValues.write(byArray);
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException(iOException);
                }
            }
        }
        return this.baosForTagValues.toByteArray();
    }

    static ByteSizeRange geByteSizeRangeOfTagValues(List<CramCompressionRecord> list, int n) {
        byte by = CompressionHeaderFactory.getTagType(n);
        ByteSizeRange byteSizeRange = new ByteSizeRange();
        for (CramCompressionRecord cramCompressionRecord : list) {
            if (cramCompressionRecord.tags == null) continue;
            for (ReadTag readTag : cramCompressionRecord.tags) {
                if (readTag.keyType3BytesAsInt != n) continue;
                int n2 = CompressionHeaderFactory.getTagValueByteSize(by, readTag.getValue());
                if (byteSizeRange.min > n2) {
                    byteSizeRange.min = n2;
                }
                if (byteSizeRange.max >= n2) continue;
                byteSizeRange.max = n2;
            }
        }
        return byteSizeRange;
    }

    static int getUnusedByte(byte[] byArray) {
        byte[] byArray2 = new byte[256];
        for (byte by : byArray) {
            byArray2[0xFF & by] = 1;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private EncodingDetails buildEncodingForTag(List<CramCompressionRecord> list, int n) {
        EncodingDetails encodingDetails = new EncodingDetails();
        byte[] byArray = this.getDataForTag(list, n);
        encodingDetails.compressor = CompressionHeaderFactory.getBestExternalCompressor(byArray);
        byte by = CompressionHeaderFactory.getTagType(n);
        switch (by) {
            case 65: 
            case 67: 
            case 99: {
                encodingDetails.params = ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(new int[]{1}, new int[]{0}), ExternalByteEncoding.toParam(n));
                return encodingDetails;
            }
            case 73: 
            case 102: 
            case 105: {
                encodingDetails.params = ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(new int[]{4}, new int[]{0}), ExternalByteEncoding.toParam(n));
                return encodingDetails;
            }
            case 83: 
            case 115: {
                encodingDetails.params = ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(new int[]{2}, new int[]{0}), ExternalByteEncoding.toParam(n));
                return encodingDetails;
            }
            case 66: 
            case 90: {
                int n2;
                boolean bl;
                ByteSizeRange byteSizeRange = CompressionHeaderFactory.geByteSizeRangeOfTagValues(list, n);
                boolean bl2 = bl = byteSizeRange.min == byteSizeRange.max;
                if (bl) {
                    encodingDetails.params = ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(new int[]{byteSizeRange.min}, new int[]{0}), ExternalByteEncoding.toParam(n));
                    return encodingDetails;
                }
                if (by == 90) {
                    encodingDetails.params = ByteArrayStopEncoding.toParam((byte)9, n);
                    return encodingDetails;
                }
                if (byteSizeRange.min > 100 && (n2 = CompressionHeaderFactory.getUnusedByte(byArray)) > -1) {
                    encodingDetails.params = ByteArrayStopEncoding.toParam((byte)n2, n);
                    return encodingDetails;
                }
                encodingDetails.params = ByteArrayLenEncoding.toParam(ExternalIntegerEncoding.toParam(n), ExternalByteEncoding.toParam(n));
                return encodingDetails;
            }
        }
        throw new IllegalArgumentException("Unknown tag type: " + (char)by);
    }

    static int getTagValueByteSize(byte by, Object object) {
        switch (by) {
            case 65: {
                return 1;
            }
            case 73: {
                return 4;
            }
            case 105: {
                return 4;
            }
            case 115: {
                return 2;
            }
            case 83: {
                return 2;
            }
            case 99: {
                return 1;
            }
            case 67: {
                return 1;
            }
            case 102: {
                return 4;
            }
            case 90: {
                return ((String)object).length() + 1;
            }
            case 66: {
                if (object instanceof byte[]) {
                    return 5 + ((byte[])object).length;
                }
                if (object instanceof short[]) {
                    return 5 + ((short[])object).length * 2;
                }
                if (object instanceof int[]) {
                    return 5 + ((int[])object).length * 4;
                }
                if (object instanceof float[]) {
                    return 5 + ((float[])object).length * 4;
                }
                if (object instanceof long[]) {
                    return 5 + ((long[])object).length * 4;
                }
                throw new RuntimeException("Unknown tag array class: " + object.getClass());
            }
        }
        throw new RuntimeException("Unknown tag type: " + (char)by);
    }

    private static class CompressionHeaderBuilder {
        private final CompressionHeader header = new CompressionHeader();

        CompressionHeaderBuilder(boolean bl) {
            this.header.externalIds = new ArrayList<Integer>();
            this.header.tMap = new TreeMap<Integer, EncodingParams>();
            this.header.encodingMap = new TreeMap<EncodingKey, EncodingParams>();
            this.header.APDelta = bl;
        }

        CompressionHeader getHeader() {
            return this.header;
        }

        void addExternalEncoding(EncodingKey encodingKey, EncodingParams encodingParams, ExternalCompressor externalCompressor) {
            this.header.externalIds.add(encodingKey.ordinal());
            this.header.externalCompressors.put(encodingKey.ordinal(), externalCompressor);
            this.header.encodingMap.put(encodingKey, encodingParams);
        }

        void addExternalByteArrayStopTabGzipEncoding(EncodingKey encodingKey) {
            this.addExternalEncoding(encodingKey, ByteArrayStopEncoding.toParam((byte)9, encodingKey.ordinal()), ExternalCompressor.createGZIP());
        }

        void addExternalIntegerEncoding(EncodingKey encodingKey, ExternalCompressor externalCompressor) {
            this.addExternalEncoding(encodingKey, ExternalIntegerEncoding.toParam(encodingKey.ordinal()), externalCompressor);
        }

        void addExternalIntegerGzipEncoding(EncodingKey encodingKey) {
            this.addExternalEncoding(encodingKey, ExternalIntegerEncoding.toParam(encodingKey.ordinal()), ExternalCompressor.createGZIP());
        }

        void addExternalByteGzipEncoding(EncodingKey encodingKey) {
            this.addExternalEncoding(encodingKey, ExternalByteEncoding.toParam(encodingKey.ordinal()), ExternalCompressor.createGZIP());
        }

        void addExternalByteRansOrderOneEncoding(EncodingKey encodingKey) {
            this.addExternalEncoding(encodingKey, ExternalByteEncoding.toParam(encodingKey.ordinal()), ExternalCompressor.createRANS(RANS.ORDER.ONE));
        }

        void addExternalIntegerRansOrderOneEncoding(EncodingKey encodingKey) {
            this.addExternalIntegerEncoding(encodingKey, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        }

        void addExternalIntegerRansOrderZeroEncoding(EncodingKey encodingKey) {
            this.addExternalIntegerEncoding(encodingKey, ExternalCompressor.createRANS(RANS.ORDER.ZERO));
        }

        void addTagEncoding(int n, EncodingDetails encodingDetails) {
            this.header.externalIds.add(n);
            this.header.externalCompressors.put(n, encodingDetails.compressor);
            this.header.tMap.put(n, encodingDetails.params);
        }

        void setTagIdDictionary(byte[][][] byArray) {
            this.header.dictionary = byArray;
        }

        void setSubstitutionMatrix(SubstitutionMatrix substitutionMatrix) {
            this.header.substitutionMatrix = substitutionMatrix;
        }
    }

    private static class EncodingDetails {
        ExternalCompressor compressor;
        EncodingParams params;

        private EncodingDetails() {
        }
    }

    static class ByteSizeRange {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;

        ByteSizeRange() {
        }
    }
}

