/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.digest.ContentDigests;
import htsjdk.samtools.cram.encoding.ExternalCompressor;
import htsjdk.samtools.cram.encoding.writer.DataWriterFactory;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFactory {
    private final SAMFileHeader samFileHeader;
    private int recordsPerSlice = 10000;
    private boolean preserveReadNames = true;
    private long globalRecordCounter = 0L;

    public ContainerFactory(SAMFileHeader sAMFileHeader, int n) {
        this.samFileHeader = sAMFileHeader;
        this.recordsPerSlice = n;
    }

    public Container buildContainer(List<CramCompressionRecord> list) throws IllegalArgumentException, IllegalAccessException, IOException {
        return this.buildContainer(list, null);
    }

    Container buildContainer(List<CramCompressionRecord> list, SubstitutionMatrix substitutionMatrix) throws IllegalArgumentException, IllegalAccessException, IOException {
        long l = System.nanoTime();
        CompressionHeader compressionHeader = new CompressionHeaderFactory().build(list, substitutionMatrix, this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate);
        compressionHeader.APDelta = this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate;
        long l2 = System.nanoTime();
        compressionHeader.readNamesIncluded = this.preserveReadNames;
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        Container container = new Container();
        container.header = compressionHeader;
        container.nofRecords = list.size();
        container.globalRecordCounter = this.globalRecordCounter;
        container.bases = 0L;
        container.blockCount = 0;
        long l3 = System.nanoTime();
        long l4 = container.globalRecordCounter;
        for (int i = 0; i < list.size(); i += this.recordsPerSlice) {
            List<CramCompressionRecord> list2 = list.subList(i, Math.min(list.size(), i + this.recordsPerSlice));
            Slice slice = ContainerFactory.buildSlice(list2, compressionHeader);
            slice.globalRecordCounter = l4;
            l4 += (long)slice.nofRecords;
            container.bases += slice.bases;
            arrayList.add(slice);
            if (container.sequenceId != -1 || slice.sequenceId == -1) continue;
            container.sequenceId = slice.sequenceId;
        }
        long l5 = System.nanoTime();
        container.slices = arrayList.toArray(new Slice[arrayList.size()]);
        ContainerFactory.calculateAlignmentBoundaries(container);
        container.buildHeaderTime = l2 - l;
        container.buildSlicesTime = l5 - l3;
        this.globalRecordCounter += (long)list.size();
        return container;
    }

    private static void calculateAlignmentBoundaries(Container container) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (Slice slice : container.slices) {
            if (slice.sequenceId == -1) continue;
            n = Math.min(n, slice.alignmentStart);
            n2 = Math.max(n2, slice.alignmentStart + slice.alignmentSpan);
        }
        if (n < Integer.MAX_VALUE) {
            container.alignmentStart = n;
            container.alignmentSpan = n2 - n;
        }
    }

    private static Slice buildSlice(List<CramCompressionRecord> list, CompressionHeader compressionHeader) throws IllegalArgumentException, IllegalAccessException, IOException {
        HashMap<Integer, ExposedByteArrayOutputStream> hashMap = new HashMap<Integer, ExposedByteArrayOutputStream>();
        Object object = compressionHeader.externalIds.iterator();
        while (object.hasNext()) {
            int n = object.next();
            hashMap.put(n, new ExposedByteArrayOutputStream());
        }
        object = new DataWriterFactory();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        DefaultBitOutputStream defaultBitOutputStream = new DefaultBitOutputStream(exposedByteArrayOutputStream);
        Slice slice = new Slice();
        slice.nofRecords = list.size();
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        slice.sequenceId = list.get((int)0).sequenceId;
        Object object2 = ContentDigests.create(ContentDigests.ALL);
        for (CramCompressionRecord iterator : list) {
            slice.bases += (long)iterator.readLength;
            ((ContentDigests)object2).add(iterator);
            if (slice.sequenceId == -2) continue;
            if (slice.sequenceId != iterator.sequenceId) {
                slice.sequenceId = -2;
                continue;
            }
            if (iterator.alignmentStart == 0) continue;
            n = Math.min(iterator.alignmentStart, n);
            n2 = Math.max(iterator.getAlignmentEnd(), n2);
        }
        slice.sliceTags = ((ContentDigests)object2).getAsTags();
        if (slice.sequenceId == -2 || n == Integer.MAX_VALUE) {
            slice.alignmentStart = -1;
            slice.alignmentSpan = 0;
        } else {
            slice.alignmentStart = n;
            slice.alignmentSpan = n2 - n + 1;
        }
        object2 = ((DataWriterFactory)object).buildWriter(defaultBitOutputStream, hashMap, compressionHeader, slice.sequenceId);
        int n3 = slice.alignmentStart;
        for (CramCompressionRecord cramCompressionRecord : list) {
            cramCompressionRecord.alignmentDelta = cramCompressionRecord.alignmentStart - n3;
            n3 = cramCompressionRecord.alignmentStart;
            ((Writer)object2).write(cramCompressionRecord);
        }
        defaultBitOutputStream.close();
        slice.coreBlock = Block.buildNewCore(exposedByteArrayOutputStream.toByteArray());
        slice.external = new HashMap<Integer, Block>();
        for (Integer n4 : hashMap.keySet()) {
            ExposedByteArrayOutputStream exposedByteArrayOutputStream2 = (ExposedByteArrayOutputStream)hashMap.get(n4);
            Block block = new Block();
            block.setContentId(n4);
            block.setContentType(BlockContentType.EXTERNAL);
            ExternalCompressor externalCompressor = compressionHeader.externalCompressors.get(n4);
            byte[] byArray = exposedByteArrayOutputStream2.toByteArray();
            byte[] byArray2 = externalCompressor.compress(byArray);
            block.setContent(byArray, byArray2);
            block.setMethod(externalCompressor.getMethod());
            slice.external.put(n4, block);
        }
        return slice;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean bl) {
        this.preserveReadNames = bl;
    }
}

