/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class SubexponentialIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int k = 2;
    private boolean unaryBit = true;

    SubexponentialIntegerCodec(int n, int n2) {
        this.offset = n;
        this.k = n2;
        this.unaryBit = true;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n;
        int n2 = 0;
        while (bitInputStream.readBit() == this.unaryBit) {
            ++n2;
        }
        if (n2 == 0) {
            int n3 = this.k;
            n = bitInputStream.readBits(n3);
        } else {
            int n4 = n2 + this.k - 1;
            n = 1 << n4 | bitInputStream.readBits(n4);
        }
        return n - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        int n2;
        int n3;
        if (n + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + n);
        }
        long l = n + this.offset;
        if (l < 1L << this.k) {
            n3 = this.k;
            n2 = 0;
        } else {
            n3 = (int)(Math.log(l) / Math.log(2.0));
            n2 = n3 - this.k + 1;
        }
        bitOutputStream.write(this.unaryBit, (long)n2);
        bitOutputStream.write(!this.unaryBit);
        bitOutputStream.write(l, n3);
        return n2 + 1 + n3;
    }

    @Override
    public final long numberOfBits(Integer n) {
        long l;
        long l2;
        long l3 = n + this.offset;
        if (l3 < 1L << this.k) {
            l2 = this.k;
            l = 0L;
        } else {
            l2 = (long)Math.floor(Math.log(l3) / Math.log(2.0));
            l = l2 - (long)this.k + 1L;
        }
        return l + 1L + l2;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

