/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import java.nio.ByteBuffer;

class Encoding {
    Encoding() {
    }

    static void RansEncSymbolInit(RansEncSymbol ransEncSymbol, int n, int n2, int n3) {
        ransEncSymbol.x_max = (0x800000 >> n3 << 8) * n2;
        ransEncSymbol.cmpl_freq = (1 << n3) - n2;
        if (n2 < 2) {
            ransEncSymbol.rcp_freq = -1;
            ransEncSymbol.rcp_shift = 0;
            ransEncSymbol.bias = n + (1 << n3) - 1;
        } else {
            int n4 = 0;
            while ((long)n2 > 1L << n4) {
                ++n4;
            }
            ransEncSymbol.rcp_freq = (int)(((1L << n4 + 31) + (long)n2 - 1L) / (long)n2);
            ransEncSymbol.rcp_shift = n4 - 1;
            ransEncSymbol.bias = n;
        }
        ransEncSymbol.rcp_shift += 32;
    }

    static int RansEncPutSymbol(int n, ByteBuffer byteBuffer, RansEncSymbol ransEncSymbol) {
        assert (ransEncSymbol.x_max != 0);
        int n2 = n;
        int n3 = ransEncSymbol.x_max;
        if (n2 >= n3 && n2 >= n3) {
            byteBuffer.put((byte)(n2 & 0xFF));
            if ((n2 >>= 8) >= n3) {
                byteBuffer.put((byte)(n2 & 0xFF));
                n2 >>= 8;
            }
        }
        long l = (long)n2 * (0xFFFFFFFFL & (long)ransEncSymbol.rcp_freq) >> ransEncSymbol.rcp_shift;
        n = (int)((long)(n2 + ransEncSymbol.bias) + l * (long)ransEncSymbol.cmpl_freq);
        return n;
    }

    static class RansEncSymbol {
        int x_max;
        int rcp_freq;
        int bias;
        int cmpl_freq;
        int rcp_shift;

        RansEncSymbol() {
        }
    }
}

