/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import htsjdk.samtools.cram.encoding.rans.D04;
import htsjdk.samtools.cram.encoding.rans.D14;
import htsjdk.samtools.cram.encoding.rans.Decoding;
import htsjdk.samtools.cram.encoding.rans.E04;
import htsjdk.samtools.cram.encoding.rans.E14;
import htsjdk.samtools.cram.encoding.rans.Encoding;
import htsjdk.samtools.cram.encoding.rans.Frequencies;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RANS {
    private static final int ORDER_BYTE_LENGTH = 1;
    private static final int COMPRESSED_BYTE_LENGTH = 4;
    private static final int RAW_BYTE_LENGTH = 4;
    private static final int PREFIX_BYTE_LENGTH = 9;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static ByteBuffer uncompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.remaining() == 0) {
            return ByteBuffer.allocate(0);
        }
        ORDER oRDER = ORDER.fromInt(byteBuffer.get());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        if (n != byteBuffer.remaining() - 4) {
            throw new RuntimeException("Incorrect input length.");
        }
        int n2 = byteBuffer.getInt();
        if (byteBuffer2 == null) {
            byteBuffer2 = ByteBuffer.allocate(n2);
        } else {
            byteBuffer2.limit(n2);
        }
        if (byteBuffer2.remaining() < n2) {
            throw new RuntimeException("Output buffer too small to fit " + n2 + " bytes.");
        }
        switch (oRDER) {
            case ZERO: {
                return RANS.uncompress_order0_way4(byteBuffer, byteBuffer2);
            }
            case ONE: {
                return RANS.uncompress_order1_way4(byteBuffer, byteBuffer2);
            }
        }
        throw new RuntimeException("Unknown rANS order: " + (Object)((Object)oRDER));
    }

    public static ByteBuffer compress(ByteBuffer byteBuffer, ORDER oRDER, ByteBuffer byteBuffer2) {
        if (byteBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        if (byteBuffer.remaining() < 4) {
            return RANS.encode_order0_way4(byteBuffer, byteBuffer2);
        }
        switch (oRDER) {
            case ZERO: {
                return RANS.encode_order0_way4(byteBuffer, byteBuffer2);
            }
            case ONE: {
                return RANS.encode_order1_way4(byteBuffer, byteBuffer2);
            }
        }
        throw new RuntimeException("Unknown rANS order: " + (Object)((Object)oRDER));
    }

    private static ByteBuffer allocateIfNeeded(int n, ByteBuffer byteBuffer) {
        int n2 = (int)(1.05 * (double)n + 198147.0 + 4.0);
        if (byteBuffer == null) {
            return ByteBuffer.allocate(n2);
        }
        if (byteBuffer.remaining() < n2) {
            throw new RuntimeException("Insufficient buffer size.");
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    private static ByteBuffer encode_order0_way4(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = byteBuffer.remaining();
        byteBuffer2 = RANS.allocateIfNeeded(n, byteBuffer2);
        byteBuffer2.position(9);
        int[] nArray = Frequencies.calcFrequencies_o0(byteBuffer);
        Encoding.RansEncSymbol[] ransEncSymbolArray = Frequencies.buildSyms_o0(nArray);
        ByteBuffer byteBuffer3 = byteBuffer2.slice();
        int n2 = Frequencies.writeFrequencies_o0(byteBuffer3, nArray);
        byteBuffer.rewind();
        int n3 = E04.compress(byteBuffer, ransEncSymbolArray, byteBuffer3);
        RANS.finalizeCompressed(0, byteBuffer2, n, n2, n3);
        return byteBuffer2;
    }

    private static ByteBuffer encode_order1_way4(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = byteBuffer.remaining();
        byteBuffer2 = RANS.allocateIfNeeded(n, byteBuffer2);
        byteBuffer2.position(9);
        int[][] nArray = Frequencies.calcFrequencies_o1(byteBuffer);
        Encoding.RansEncSymbol[][] ransEncSymbolArray = Frequencies.buildSyms_o1(nArray);
        ByteBuffer byteBuffer3 = byteBuffer2.slice();
        int n2 = Frequencies.writeFrequencies_o1(byteBuffer3, nArray);
        byteBuffer.rewind();
        int n3 = E14.compress(byteBuffer, ransEncSymbolArray, byteBuffer3);
        RANS.finalizeCompressed(1, byteBuffer2, n, n2, n3);
        return byteBuffer2;
    }

    private static void finalizeCompressed(int n, ByteBuffer byteBuffer, int n2, int n3, int n4) {
        byteBuffer.limit(9 + n3 + n4);
        byteBuffer.put(0, (byte)n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(1, n3 + n4);
        byteBuffer.putInt(5, n2);
        byteBuffer.rewind();
    }

    private static ByteBuffer uncompress_order0_way4(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Decoding.AriDecoder ariDecoder = new Decoding.AriDecoder();
        Decoding.RansDecSymbol[] ransDecSymbolArray = new Decoding.RansDecSymbol[256];
        for (int i = 0; i < ransDecSymbolArray.length; ++i) {
            ransDecSymbolArray[i] = new Decoding.RansDecSymbol();
        }
        Frequencies.readStats_o0(byteBuffer, ariDecoder, ransDecSymbolArray);
        D04.uncompress(byteBuffer, ariDecoder, ransDecSymbolArray, byteBuffer2);
        return byteBuffer2;
    }

    private static ByteBuffer uncompress_order1_way4(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Decoding.AriDecoder[] ariDecoderArray = new Decoding.AriDecoder[256];
        Decoding.RansDecSymbol[][] ransDecSymbolArray = new Decoding.RansDecSymbol[256][256];
        for (int i = 0; i < ransDecSymbolArray.length; ++i) {
            for (int j = 0; j < ransDecSymbolArray[i].length; ++j) {
                ransDecSymbolArray[i][j] = new Decoding.RansDecSymbol();
            }
        }
        Frequencies.readStats_o1(byteBuffer, ariDecoderArray, ransDecSymbolArray);
        D14.uncompress(byteBuffer, byteBuffer2, ariDecoderArray, ransDecSymbolArray);
        return byteBuffer2;
    }

    public static enum ORDER {
        ZERO,
        ONE;


        public static ORDER fromInt(int n) {
            try {
                return ORDER.values()[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new RuntimeException("Unknown rANS order: " + n);
            }
        }
    }
}

