/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Scores;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.util.LinkedList;

public class CramRecordReader
extends AbstractReader {
    private CramCompressionRecord prevRecord;
    private ValidationStringency validationStringency;

    public CramRecordReader(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public void read(CramCompressionRecord cramCompressionRecord) {
        try {
            Comparable<Byte> comparable;
            int n;
            int n2;
            cramCompressionRecord.flags = (Integer)this.bitFlagsCodec.readData();
            cramCompressionRecord.compressionFlags = ((Byte)this.compressionBitFlagsCodec.readData()).byteValue();
            cramCompressionRecord.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            cramCompressionRecord.readLength = (Integer)this.readLengthCodec.readData();
            if (this.APDelta) {
                cramCompressionRecord.alignmentDelta = (Integer)this.alignmentStartCodec.readData();
            } else {
                cramCompressionRecord.alignmentStart = (Integer)this.alignmentStartCodec.readData();
            }
            cramCompressionRecord.readGroupID = (Integer)this.readGroupCodec.readData();
            if (this.captureReadNames) {
                cramCompressionRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
            }
            if (cramCompressionRecord.isDetached()) {
                cramCompressionRecord.mateFlags = ((Byte)this.mateBitFlagCodec.readData()).byteValue();
                if (!this.captureReadNames) {
                    cramCompressionRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
                }
                cramCompressionRecord.mateSequenceID = (Integer)this.mateReferenceIdCodec.readData();
                cramCompressionRecord.mateAlignmentStart = (Integer)this.mateAlignmentStartCodec.readData();
                cramCompressionRecord.templateSize = (Integer)this.insertSizeCodec.readData();
                ++detachedCount;
            } else if (cramCompressionRecord.isHasMateDownStream()) {
                cramCompressionRecord.recordsToNextFragment = (Integer)this.distanceToNextFragmentCodec.readData();
            }
            Integer n3 = (Integer)this.tagIdListCodec.readData();
            byte[][] byArray = this.tagIdDictionary[n3];
            if (byArray.length > 0) {
                n2 = byArray.length;
                cramCompressionRecord.tags = new ReadTag[n2];
                for (n = 0; n < byArray.length; ++n) {
                    int n4 = ReadTag.name3BytesToInt(byArray[n]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(n4);
                    comparable = new ReadTag(n4, (byte[])dataReader.readData(), this.validationStringency);
                    cramCompressionRecord.tags[n] = comparable;
                }
            }
            if (!cramCompressionRecord.isSegmentUnmapped()) {
                n2 = (Integer)this.numberOfReadFeaturesCodec.readData();
                n = 0;
                LinkedList<ReadFeature> linkedList = new LinkedList<ReadFeature>();
                cramCompressionRecord.readFeatures = linkedList;
                block18: for (int i = 0; i < n2; ++i) {
                    int n5;
                    comparable = (Byte)this.readFeatureCodeCodec.readData();
                    n = n5 = n + (Integer)this.readFeaturePositionCodec.readData();
                    switch ((Byte)comparable) {
                        case 66: {
                            ReadBase readBase = new ReadBase(n5, (Byte)this.baseCodec.readData(), (Byte)this.qualityScoreCodec.readData());
                            linkedList.add(readBase);
                            continue block18;
                        }
                        case 88: {
                            Substitution substitution = new Substitution();
                            substitution.setPosition(n5);
                            byte by = (Byte)this.baseSubstitutionCodec.readData();
                            substitution.setCode(by);
                            linkedList.add(substitution);
                            continue block18;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(n5, (byte[])this.insertionCodec.readData());
                            linkedList.add(insertion);
                            continue block18;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(n5, (byte[])this.softClipCodec.readData());
                            linkedList.add(softClip);
                            continue block18;
                        }
                        case 72: {
                            HardClip hardClip = new HardClip(n5, (Integer)this.hardClipCodec.readData());
                            linkedList.add(hardClip);
                            continue block18;
                        }
                        case 80: {
                            Padding padding = new Padding(n5, (Integer)this.paddingCodec.readData());
                            linkedList.add(padding);
                            continue block18;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(n5, (Integer)this.deletionLengthCodec.readData());
                            linkedList.add(deletion);
                            continue block18;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(n5, (Integer)this.refSkipCodec.readData());
                            linkedList.add(refSkip);
                            continue block18;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(n5, (Byte)this.baseCodec.readData());
                            linkedList.add(insertBase);
                            continue block18;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(n5, (Byte)this.qualityScoreCodec.readData());
                            linkedList.add(baseQualityScore);
                            continue block18;
                        }
                        case 98: {
                            Bases bases = new Bases(n5, (byte[])this.basesCodec.readData());
                            linkedList.add(bases);
                            continue block18;
                        }
                        case 113: {
                            Scores scores = new Scores(n5, (byte[])this.scoresCodec.readData());
                            linkedList.add(scores);
                            continue block18;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + comparable);
                        }
                    }
                }
                cramCompressionRecord.mappingQuality = (Integer)this.mappingScoreCodec.readData();
                if (cramCompressionRecord.isForcePreserveQualityScores()) {
                    cramCompressionRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(cramCompressionRecord.readLength);
                }
            } else if (cramCompressionRecord.isUnknownBases()) {
                cramCompressionRecord.readBases = SAMRecord.NULL_SEQUENCE;
                cramCompressionRecord.qualityScores = SAMRecord.NULL_QUALS;
            } else {
                byte[] byArray2 = new byte[cramCompressionRecord.readLength];
                for (n = 0; n < byArray2.length; ++n) {
                    byArray2[n] = (Byte)this.baseCodec.readData();
                }
                cramCompressionRecord.readBases = byArray2;
                if (cramCompressionRecord.isForcePreserveQualityScores()) {
                    cramCompressionRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(cramCompressionRecord.readLength);
                }
            }
            ++this.recordCounter;
            this.prevRecord = cramCompressionRecord;
        }
        catch (SAMFormatException sAMFormatException) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw sAMFormatException;
        }
        catch (Exception exception) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw new RuntimeException(exception);
        }
    }
}

