/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Scores;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RefSeqIdReader
extends AbstractReader {
    private final int globalReferenceSequenceId;
    private int alignmentStart;
    private ValidationStringency validationStringency;
    private int recordCounter = 0;
    private final CramCompressionRecord cramRecord = new CramCompressionRecord();
    private final Map<Integer, AlignmentSpan> spans = new HashMap<Integer, AlignmentSpan>();

    public RefSeqIdReader(int n, int n2, ValidationStringency validationStringency) {
        this.globalReferenceSequenceId = n;
        this.alignmentStart = n2;
        this.validationStringency = validationStringency;
    }

    public Map<Integer, AlignmentSpan> getReferenceSpans() {
        return this.spans;
    }

    public void read() {
        this.cramRecord.sequenceId = this.globalReferenceSequenceId;
        try {
            Comparable<Byte> comparable;
            int n;
            int n2;
            this.cramRecord.flags = (Integer)this.bitFlagsCodec.readData();
            this.cramRecord.compressionFlags = ((Byte)this.compressionBitFlagsCodec.readData()).byteValue();
            this.cramRecord.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            this.cramRecord.readLength = (Integer)this.readLengthCodec.readData();
            if (this.APDelta) {
                this.cramRecord.alignmentDelta = (Integer)this.alignmentStartCodec.readData();
                this.alignmentStart += this.cramRecord.alignmentDelta;
            } else {
                this.alignmentStart = this.cramRecord.alignmentStart = ((Integer)this.alignmentStartCodec.readData()).intValue();
            }
            this.cramRecord.readGroupID = (Integer)this.readGroupCodec.readData();
            if (this.captureReadNames) {
                this.cramRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
            }
            if (this.cramRecord.isDetached()) {
                this.cramRecord.mateFlags = ((Byte)this.mateBitFlagCodec.readData()).byteValue();
                if (!this.captureReadNames) {
                    this.cramRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
                }
                this.cramRecord.mateSequenceID = (Integer)this.mateReferenceIdCodec.readData();
                this.cramRecord.mateAlignmentStart = (Integer)this.mateAlignmentStartCodec.readData();
                this.cramRecord.templateSize = (Integer)this.insertSizeCodec.readData();
                ++detachedCount;
            } else if (this.cramRecord.isHasMateDownStream()) {
                this.cramRecord.recordsToNextFragment = (Integer)this.distanceToNextFragmentCodec.readData();
            }
            Integer n3 = (Integer)this.tagIdListCodec.readData();
            byte[][] byArray = this.tagIdDictionary[n3];
            if (byArray.length > 0) {
                n2 = byArray.length;
                this.cramRecord.tags = new ReadTag[n2];
                for (n = 0; n < byArray.length; ++n) {
                    int n4 = ReadTag.name3BytesToInt(byArray[n]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(n4);
                    comparable = new ReadTag(n4, (byte[])dataReader.readData(), this.validationStringency);
                    this.cramRecord.tags[n] = comparable;
                }
            }
            if (!this.cramRecord.isSegmentUnmapped()) {
                n2 = (Integer)this.numberOfReadFeaturesCodec.readData();
                n = 0;
                LinkedList<ReadFeature> linkedList = new LinkedList<ReadFeature>();
                this.cramRecord.readFeatures = linkedList;
                block17: for (int i = 0; i < n2; ++i) {
                    int n5;
                    comparable = (Byte)this.readFeatureCodeCodec.readData();
                    n = n5 = n + (Integer)this.readFeaturePositionCodec.readData();
                    switch ((Byte)comparable) {
                        case 66: {
                            ReadBase readBase = new ReadBase(n5, (Byte)this.baseCodec.readData(), (Byte)this.qualityScoreCodec.readData());
                            linkedList.add(readBase);
                            continue block17;
                        }
                        case 88: {
                            Substitution substitution = new Substitution();
                            substitution.setPosition(n5);
                            byte by = (Byte)this.baseSubstitutionCodec.readData();
                            substitution.setCode(by);
                            linkedList.add(substitution);
                            continue block17;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(n5, (byte[])this.insertionCodec.readData());
                            linkedList.add(insertion);
                            continue block17;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(n5, (byte[])this.softClipCodec.readData());
                            linkedList.add(softClip);
                            continue block17;
                        }
                        case 72: {
                            HardClip hardClip = new HardClip(n5, (Integer)this.hardClipCodec.readData());
                            linkedList.add(hardClip);
                            continue block17;
                        }
                        case 80: {
                            Padding padding = new Padding(n5, (Integer)this.paddingCodec.readData());
                            linkedList.add(padding);
                            continue block17;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(n5, (Integer)this.deletionLengthCodec.readData());
                            linkedList.add(deletion);
                            continue block17;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(n5, (Integer)this.refSkipCodec.readData());
                            linkedList.add(refSkip);
                            continue block17;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(n5, (Byte)this.baseCodec.readData());
                            linkedList.add(insertBase);
                            continue block17;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(n5, (Byte)this.qualityScoreCodec.readData());
                            linkedList.add(baseQualityScore);
                            continue block17;
                        }
                        case 98: {
                            Bases bases = new Bases(n5, (byte[])this.basesCodec.readData());
                            linkedList.add(bases);
                            continue block17;
                        }
                        case 113: {
                            Scores scores = new Scores(n5, (byte[])this.scoresCodec.readData());
                            linkedList.add(scores);
                            continue block17;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + comparable);
                        }
                    }
                }
                this.cramRecord.mappingQuality = (Integer)this.mappingScoreCodec.readData();
                if (this.cramRecord.isForcePreserveQualityScores()) {
                    this.cramRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(this.cramRecord.readLength);
                }
            } else if (this.cramRecord.isUnknownBases()) {
                this.cramRecord.readBases = SAMRecord.NULL_SEQUENCE;
                this.cramRecord.qualityScores = SAMRecord.NULL_QUALS;
            } else {
                byte[] byArray2 = new byte[this.cramRecord.readLength];
                for (n = 0; n < byArray2.length; ++n) {
                    byArray2[n] = (Byte)this.baseCodec.readData();
                }
                this.cramRecord.readBases = byArray2;
                if (this.cramRecord.isForcePreserveQualityScores()) {
                    this.cramRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(this.cramRecord.readLength);
                }
            }
            ++this.recordCounter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        if (!this.spans.containsKey(this.cramRecord.sequenceId)) {
            this.spans.put(this.cramRecord.sequenceId, new AlignmentSpan(this.alignmentStart, this.cramRecord.readLength));
        } else {
            this.spans.get(this.cramRecord.sequenceId).addSingle(this.alignmentStart, this.cramRecord.readLength);
        }
    }
}

