/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

public class AlignmentSpan {
    public static final AlignmentSpan UNMAPPED_SPAN = new AlignmentSpan(0, 0);
    private int start;
    private int span;
    private int count;

    public AlignmentSpan(int n, int n2) {
        this.setStart(n);
        this.setSpan(n2);
        this.count = 1;
    }

    public AlignmentSpan(int n, int n2, int n3) {
        this.setStart(n);
        this.setSpan(n2);
        this.count = n3;
    }

    public void add(int n, int n2, int n3) {
        if (this.getStart() > n) {
            this.setSpan(Math.max(this.getStart() + this.getSpan(), n + n2) - n);
            this.setStart(n);
        } else if (this.getStart() < n) {
            this.setSpan(Math.max(this.getStart() + this.getSpan(), n + n2) - this.getStart());
        } else {
            this.setSpan(Math.max(this.getSpan(), n2));
        }
        this.count += n3;
    }

    public void addSingle(int n, int n2) {
        this.add(n, n2, 1);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        this.span = n;
    }

    public int getCount() {
        return this.count;
    }
}

