/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.example;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class PrintReadsExample {
    private static final Log log = Log.getInstance(PrintReadsExample.class);

    private PrintReadsExample() {
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            System.out.println("Usage: " + PrintReadsExample.class.getCanonicalName() + " inFile eagerDecode [outFile]");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        boolean bl = Boolean.parseBoolean(stringArray[1]);
        File file2 = stringArray.length >= 3 ? new File(stringArray[2]) : null;
        long l = System.currentTimeMillis();
        log.info("Start with args:" + Arrays.toString(stringArray));
        PrintReadsExample.printConfigurationInfo();
        SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
        if (bl) {
            samReaderFactory = samReaderFactory.enable(SamReaderFactory.Option.EAGERLY_DECODE);
        }
        try (SamReader samReader = samReaderFactory.open(file);){
            SAMFileHeader sAMFileHeader = samReader.getFileHeader();
            try (SAMFileWriter sAMFileWriter = file2 != null ? new SAMFileWriterFactory().makeBAMWriter(sAMFileHeader, true, file2) : null;){
                ProgressLogger progressLogger = new ProgressLogger(log, 1000000);
                for (SAMRecord sAMRecord : samReader) {
                    if (sAMFileWriter != null) {
                        sAMFileWriter.addAlignment(sAMRecord);
                    }
                    progressLogger.record(sAMRecord);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        log.info(String.format("Done. Elapsed time %.3f seconds", (double)(l2 - l) / 1000.0));
    }

    private static void printConfigurationInfo() throws IOException {
        log.info("Executing as " + System.getProperty("user.name") + '@' + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + ' ' + System.getProperty("java.runtime.version") + ' ' + (DeflaterFactory.usingIntelDeflater() ? "IntelDeflater" : "JdkDeflater"));
        List list = Defaults.allDefaults().entrySet().stream().map(entry -> (String)entry.getKey() + ':' + entry.getValue()).collect(Collectors.toList());
        log.info(String.join((CharSequence)" ", list));
    }
}

