/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.fastq.AsyncFastqWriter;
import htsjdk.samtools.fastq.BasicFastqWriter;
import htsjdk.samtools.fastq.FastqWriter;
import java.io.File;

public class FastqWriterFactory {
    boolean useAsyncIo = Defaults.USE_ASYNC_IO_FOR_SAMTOOLS;
    boolean createMd5 = Defaults.CREATE_MD5;

    public void setUseAsyncIo(boolean bl) {
        this.useAsyncIo = bl;
    }

    public void setCreateMd5(boolean bl) {
        this.createMd5 = bl;
    }

    public FastqWriter newWriter(File file) {
        BasicFastqWriter basicFastqWriter = new BasicFastqWriter(file, this.createMd5);
        if (this.useAsyncIo) {
            return new AsyncFastqWriter(basicFastqWriter, 2000);
        }
        return basicFastqWriter;
    }
}

