/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.RuntimeScriptException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public abstract class AbstractJavascriptFilter<HEADER, TYPE> {
    public static final String DEFAULT_HEADER_KEY = "header";
    private CompiledScript script = null;
    protected Bindings bindings;

    protected AbstractJavascriptFilter(File file, HEADER HEADER) throws IOException {
        this(new FileReader(file), HEADER);
    }

    protected AbstractJavascriptFilter(String string, HEADER HEADER) {
        this(new StringReader(string), HEADER);
    }

    protected AbstractJavascriptFilter(Reader reader, HEADER HEADER) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        if (scriptEngine == null) {
            CloserUtil.close(reader);
            throw new RuntimeScriptException("The embedded 'javascript' engine is not available in java. Do you use the SUN/Oracle Java Runtime ?");
        }
        if (reader == null) {
            throw new RuntimeScriptException("missing ScriptReader.");
        }
        try {
            Compilable compilable = AbstractJavascriptFilter.getCompilable(scriptEngine);
            this.script = compilable.compile(reader);
        }
        catch (ScriptException scriptException) {
            throw new RuntimeScriptException("Script error in input", scriptException);
        }
        finally {
            CloserUtil.close(reader);
        }
        this.bindings = new SimpleBindings();
        this.bindings.put(DEFAULT_HEADER_KEY, HEADER);
    }

    private static Compilable getCompilable(ScriptEngine scriptEngine) {
        if (!(scriptEngine instanceof Compilable)) {
            throw new IllegalStateException("The current javascript engine (" + scriptEngine.getClass() + ") cannot be cast to Compilable. " + "Do you use the SUN/Oracle Java Runtime ?");
        }
        return (Compilable)Compilable.class.cast(scriptEngine);
    }

    public String getHeaderKey() {
        return DEFAULT_HEADER_KEY;
    }

    public abstract String getRecordKey();

    protected boolean accept(TYPE TYPE2) {
        try {
            this.bindings.put(this.getRecordKey(), TYPE2);
            Object object = this.script.eval(this.bindings);
            if (object == null) {
                return false;
            }
            if (object instanceof Boolean) {
                return Boolean.TRUE.equals(object);
            }
            if (object instanceof Number) {
                return ((Number)object).intValue() == 1;
            }
            return false;
        }
        catch (ScriptException scriptException) {
            throw new RuntimeException(scriptException);
        }
    }
}

