/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.AbstractFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.FastaSequenceIndexEntry;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;

public class IndexedFastaSequenceFile
extends AbstractFastaSequenceFile
implements Closeable {
    private final SeekableByteChannel channel;
    private final FastaSequenceIndex index;
    private Iterator<FastaSequenceIndexEntry> indexIterator;

    public IndexedFastaSequenceFile(File file, FastaSequenceIndex fastaSequenceIndex) {
        this(file == null ? null : file.toPath(), fastaSequenceIndex);
    }

    public IndexedFastaSequenceFile(File file) throws FileNotFoundException {
        this(file, new FastaSequenceIndex(IndexedFastaSequenceFile.findRequiredFastaIndexFile(file)));
    }

    public IndexedFastaSequenceFile(Path path, FastaSequenceIndex fastaSequenceIndex) {
        super(path);
        if (fastaSequenceIndex == null) {
            throw new IllegalArgumentException("Null index for fasta " + path);
        }
        this.index = fastaSequenceIndex;
        IOUtil.assertFileIsReadable(path);
        try {
            this.channel = Files.newByteChannel(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new SAMException("Fasta file should be readable but is not: " + path, iOException);
        }
        this.reset();
        if (this.getSequenceDictionary() != null) {
            IndexedFastaSequenceFile.sanityCheckDictionaryAgainstIndex(path.toAbsolutePath().toString(), this.sequenceDictionary, fastaSequenceIndex);
        }
    }

    public IndexedFastaSequenceFile(Path path) throws FileNotFoundException {
        this(path, new FastaSequenceIndex(IndexedFastaSequenceFile.findRequiredFastaIndexFile(path)));
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    private static File findFastaIndex(File file) {
        File file2 = IndexedFastaSequenceFile.getFastaIndexFileName(file);
        if (!file2.exists()) {
            return null;
        }
        return file2;
    }

    private static File getFastaIndexFileName(File file) {
        return new File(file.getAbsolutePath() + ".fai");
    }

    private static File findRequiredFastaIndexFile(File file) throws FileNotFoundException {
        File file2 = IndexedFastaSequenceFile.findFastaIndex(file);
        if (file2 == null) {
            throw new FileNotFoundException(IndexedFastaSequenceFile.getFastaIndexFileName(file) + " not found.");
        }
        return file2;
    }

    public static boolean canCreateIndexedFastaReader(File file) {
        return file.exists() && IndexedFastaSequenceFile.findFastaIndex(file) != null;
    }

    private static Path findFastaIndex(Path path) {
        Path path2 = IndexedFastaSequenceFile.getFastaIndexFileName(path);
        if (!Files.exists(path2, new LinkOption[0])) {
            return null;
        }
        return path2;
    }

    private static Path getFastaIndexFileName(Path path) {
        return path.resolveSibling(path.getFileName() + ".fai");
    }

    private static Path findRequiredFastaIndexFile(Path path) throws FileNotFoundException {
        Path path2 = IndexedFastaSequenceFile.findFastaIndex(path);
        if (path2 == null) {
            throw new FileNotFoundException(IndexedFastaSequenceFile.getFastaIndexFileName(path) + " not found.");
        }
        return path2;
    }

    public static boolean canCreateIndexedFastaReader(Path path) {
        return Files.exists(path, new LinkOption[0]) && IndexedFastaSequenceFile.findFastaIndex(path) != null;
    }

    protected static void sanityCheckDictionaryAgainstIndex(String string, SAMSequenceDictionary sAMSequenceDictionary, FastaSequenceIndex fastaSequenceIndex) {
        if (sAMSequenceDictionary.getSequences().size() != fastaSequenceIndex.size()) {
            throw new SAMException("Sequence dictionary and index contain different numbers of contigs");
        }
        Iterator<SAMSequenceRecord> iterator = sAMSequenceDictionary.getSequences().iterator();
        Iterator<FastaSequenceIndexEntry> iterator2 = fastaSequenceIndex.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            SAMSequenceRecord sAMSequenceRecord = iterator.next();
            FastaSequenceIndexEntry fastaSequenceIndexEntry = iterator2.next();
            if (!sAMSequenceRecord.getSequenceName().equals(fastaSequenceIndexEntry.getContig())) {
                throw new SAMException(String.format("Mismatch between sequence dictionary fasta index for %s, sequence '%s' != '%s'.", string, sAMSequenceRecord.getSequenceName(), fastaSequenceIndexEntry.getContig()));
            }
            if ((long)sAMSequenceRecord.getSequenceLength() == fastaSequenceIndexEntry.getSize()) continue;
            throw new SAMException("Index length does not match dictionary length for contig: " + sAMSequenceRecord.getSequenceName());
        }
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public ReferenceSequence getSequence(String string) {
        return this.getSubsequenceAt(string, 1L, (int)this.index.getIndexEntry(string).getSize());
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String string, long l, long l2) {
        if (l > l2 + 1L) {
            throw new SAMException(String.format("Malformed query; start point %d lies after end point %d", l, l2));
        }
        FastaSequenceIndexEntry fastaSequenceIndexEntry = this.index.getIndexEntry(string);
        if (l2 > fastaSequenceIndexEntry.getSize()) {
            throw new SAMException("Query asks for data past end of contig");
        }
        int n = (int)(l2 - l + 1L);
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = fastaSequenceIndexEntry.getBasesPerLine();
        int n3 = fastaSequenceIndexEntry.getBytesPerLine();
        int n4 = n3 - n2;
        long l3 = (l - 1L) / (long)n2 * (long)n3 + (l - 1L) % (long)n2;
        long l4 = Math.min((long)Defaults.NON_ZERO_BUFFER_SIZE, (long)(n / n2 + 2) * (long)n3);
        if (l4 > Integer.MAX_VALUE) {
            throw new SAMException("Buffer is too large: " + l4);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)l4);
        while (byteBuffer.position() < n) {
            l3 += (long)Math.max((int)(l3 % (long)n3 - (long)n2 + 1L), 0);
            try {
                l3 += (long)IndexedFastaSequenceFile.readFromPosition(this.channel, byteBuffer2, fastaSequenceIndexEntry.getLocation() + l3);
            }
            catch (IOException iOException) {
                throw new SAMException("Unable to load " + string + "(" + l + ", " + l2 + ") from " + this.getAbsolutePath(), iOException);
            }
            byteBuffer2.flip();
            int n5 = (int)l - 1 + byteBuffer.position();
            int n6 = Math.min(n2 - n5 % n2, n - byteBuffer.position());
            int n7 = Math.min(n6, byteBuffer2.capacity());
            byteBuffer2.limit(byteBuffer2.position() + n7);
            while (byteBuffer2.hasRemaining()) {
                byteBuffer.put(byteBuffer2);
                n7 = Math.min(n2, n - byteBuffer.position());
                byteBuffer2.limit(Math.min(byteBuffer2.position() + n7 + n4, byteBuffer2.capacity()));
                byteBuffer2.position(Math.min(byteBuffer2.position() + n4, byteBuffer2.capacity()));
            }
            byteBuffer2.flip();
        }
        return new ReferenceSequence(string, fastaSequenceIndexEntry.getSequenceIndex(), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readFromPosition(SeekableByteChannel seekableByteChannel, ByteBuffer byteBuffer, long l) throws IOException {
        if (seekableByteChannel instanceof FileChannel) {
            return ((FileChannel)seekableByteChannel).read(byteBuffer, l);
        }
        long l2 = seekableByteChannel.position();
        try {
            seekableByteChannel.position(l);
            int n = seekableByteChannel.read(byteBuffer);
            return n;
        }
        finally {
            seekableByteChannel.position(l2);
        }
    }

    @Override
    public ReferenceSequence nextSequence() {
        if (!this.indexIterator.hasNext()) {
            return null;
        }
        return this.getSequence(this.indexIterator.next().getContig());
    }

    @Override
    public void reset() {
        this.indexIterator = this.index.iterator();
    }

    @Override
    public String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

