/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SeekableMemoryStream
extends SeekableStream {
    private final ByteBuffer buf;
    private final String source;

    public SeekableMemoryStream(byte[] byArray, String string) {
        this.buf = ByteBuffer.wrap(byArray);
        this.source = string;
    }

    @Override
    public void close() throws IOException {
        this.buf.clear();
    }

    @Override
    public boolean eof() throws IOException {
        return this.buf.position() == this.buf.limit();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public long length() {
        return this.buf.array().length - this.buf.arrayOffset();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(n2, this.buf.remaining());
        if (n3 < 1) {
            return -1;
        }
        this.buf.get(byArray, n, n3);
        return n3;
    }

    @Override
    public void seek(long l) throws IOException {
        this.buf.position((int)l);
    }

    @Override
    public int read() throws IOException {
        if (this.buf.position() < this.buf.limit()) {
            return this.buf.get();
        }
        return -1;
    }

    @Override
    public long position() throws IOException {
        return this.buf.position();
    }
}

