/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.util.ArrayList;
import java.util.List;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.Reference;

public class ReferenceCache {
    private ReadCollection run;
    private SAMFileHeader virtualHeader;
    private final List<Reference> cachedReferences;

    public ReferenceCache(ReadCollection readCollection, SAMFileHeader sAMFileHeader) {
        this.run = readCollection;
        this.virtualHeader = sAMFileHeader;
        this.cachedReferences = this.initializeReferenceCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference get(int n) {
        Reference reference = this.cachedReferences.get(n);
        if (reference != null) {
            return reference;
        }
        ReferenceCache referenceCache = this;
        synchronized (referenceCache) {
            reference = this.cachedReferences.get(n);
            if (reference == null) {
                try {
                    reference = this.run.getReference(this.virtualHeader.getSequence(n).getSequenceName());
                }
                catch (ErrorMsg errorMsg) {
                    throw new RuntimeException(errorMsg);
                }
                this.cachedReferences.set(n, reference);
            }
        }
        return reference;
    }

    private List<Reference> initializeReferenceCache() {
        if (this.virtualHeader == null) {
            throw new RuntimeException("Cannot cache references - header is uninitialized");
        }
        SAMSequenceDictionary sAMSequenceDictionary = this.virtualHeader.getSequenceDictionary();
        ArrayList<Reference> arrayList = new ArrayList<Reference>(sAMSequenceDictionary.size());
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            arrayList.add(null);
        }
        return arrayList;
    }
}

