/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SRAIterator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.sra.ReferenceCache;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.sra.SRALazyRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ngs.AlignmentIterator;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.Reference;

public class SRAAlignmentIterator
implements Iterator<SAMRecord> {
    private ValidationStringency validationStringency;
    private SRAAccession accession;
    private ReadCollection run;
    private SAMFileHeader header;
    private ReferenceCache cachedReferences;
    private List<Long> referencesLengths;
    private Iterator<Chunk> referencesChunksIterator;
    private int currentReference = -1;
    private boolean hasMoreReferences = true;
    private AlignmentIterator alignedIterator;
    private Boolean hasMoreAlignments = false;
    private SRALazyRecord lastRecord;

    public SRAAlignmentIterator(SRAAccession sRAAccession, ReadCollection readCollection, SAMFileHeader sAMFileHeader, ReferenceCache referenceCache, SRAIterator.RecordRangeInfo recordRangeInfo, Chunk chunk) {
        this.accession = sRAAccession;
        this.run = readCollection;
        this.header = sAMFileHeader;
        this.cachedReferences = referenceCache;
        this.referencesLengths = recordRangeInfo.getReferenceLengthsAligned();
        this.referencesChunksIterator = this.getReferenceChunks(chunk).iterator();
        try {
            this.nextReference();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasMoreAlignments == null) {
            try {
                this.lastRecord.detachFromIterator();
                this.hasMoreAlignments = this.alignedIterator.nextAlignment();
            }
            catch (ErrorMsg errorMsg) {
                throw new RuntimeException(errorMsg);
            }
        }
        while (!this.hasMoreAlignments.booleanValue() && this.hasMoreReferences) {
            this.nextReference();
        }
        return this.hasMoreAlignments;
    }

    @Override
    public SAMRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more alignments are available");
        }
        return this.nextAlignment();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal of records not implemented.");
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    private SAMRecord nextAlignment() {
        try {
            this.lastRecord = new SRALazyRecord(this.header, this.accession, this.run, this.alignedIterator, this.alignedIterator.getReadId(), this.alignedIterator.getAlignmentId());
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        if (this.validationStringency != null) {
            this.lastRecord.setValidationStringency(this.validationStringency);
        }
        this.hasMoreAlignments = null;
        return this.lastRecord;
    }

    private void nextReference() {
        if (!this.hasMoreReferences) {
            throw new NoSuchElementException("Cannot get next reference - already at last one");
        }
        try {
            this.hasMoreReferences = this.referencesChunksIterator.hasNext();
            if (!this.hasMoreReferences) {
                this.hasMoreAlignments = false;
                return;
            }
            ++this.currentReference;
            Chunk chunk = this.referencesChunksIterator.next();
            if (chunk == null) {
                this.hasMoreAlignments = false;
                return;
            }
            Reference reference = this.cachedReferences.get(this.currentReference);
            this.alignedIterator = reference.getFilteredAlignmentSlice(chunk.getChunkStart(), chunk.getChunkEnd() - chunk.getChunkStart(), 3, 35, 0);
            this.hasMoreAlignments = this.alignedIterator.nextAlignment();
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private List<Chunk> getReferenceChunks(Chunk chunk) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        long l = 0L;
        for (Long l2 : this.referencesLengths) {
            if (chunk.getChunkStart() - l >= l2 || chunk.getChunkEnd() - l <= 0L) {
                arrayList.add(null);
            } else {
                long l3 = Math.max(chunk.getChunkStart() - l, 0L);
                long l4 = Math.min(chunk.getChunkEnd() - l, l2);
                arrayList.add(new Chunk(l3, l4));
            }
            l += l2.longValue();
        }
        return arrayList;
    }
}

