/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.sra.SRAAccession;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.Reference;
import ngs.ReferenceIterator;

public class SRAIndexedSequenceFile
implements ReferenceSequenceFile {
    private SRAAccession acc;
    private ReadCollection run;
    private ThreadLocal<HashMap<Integer, Reference>> cachedReferences = new ThreadLocal();
    private Iterator<SAMSequenceRecord> sequenceRecordIterator;
    protected SAMSequenceDictionary sequenceDictionary;

    public SRAIndexedSequenceFile(SRAAccession sRAAccession) {
        this.acc = sRAAccession;
        if (!sRAAccession.isValid()) {
            throw new RuntimeException("Passed an invalid SRA accession into SRA reader: " + sRAAccession);
        }
        try {
            this.run = NGS.openReadCollection((String)sRAAccession.toString());
            this.sequenceDictionary = this.loadSequenceDictionary();
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        this.reset();
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public ReferenceSequence nextSequence() {
        SAMSequenceRecord sAMSequenceRecord = this.sequenceRecordIterator.next();
        return this.getSubsequenceAt(sAMSequenceRecord.getSequenceName(), 1L, sAMSequenceRecord.getSequenceLength());
    }

    @Override
    public void reset() {
        this.sequenceRecordIterator = this.sequenceDictionary.getSequences().iterator();
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ReferenceSequence getSequence(String string) {
        return this.getSubsequenceAt(string, 1L, this.sequenceDictionary.getSequence(string).getSequenceLength());
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String string, long l, long l2) {
        byte[] byArray;
        SAMSequenceRecord sAMSequenceRecord = this.sequenceDictionary.getSequence(string);
        int n = sAMSequenceRecord.getSequenceIndex();
        try {
            Reference reference;
            HashMap<Integer, Object> hashMap = this.cachedReferences.get();
            if (hashMap == null) {
                hashMap = new HashMap();
                this.cachedReferences.set(hashMap);
            }
            if ((reference = hashMap.get(n)) == null) {
                reference = this.run.getReference(string);
                hashMap.put(n, reference);
            }
            byArray = reference.getReferenceBases(l - 1L, l2 - (l - 1L)).getBytes();
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return new ReferenceSequence(string, n, byArray);
    }

    @Override
    public void close() throws IOException {
    }

    protected SAMSequenceDictionary loadSequenceDictionary() throws ErrorMsg {
        SAMSequenceDictionary sAMSequenceDictionary = new SAMSequenceDictionary();
        ReferenceIterator referenceIterator = this.run.getReferences();
        while (referenceIterator.nextReference()) {
            sAMSequenceDictionary.addSequence(new SAMSequenceRecord(referenceIterator.getCanonicalName(), (int)referenceIterator.getLength()));
        }
        return sAMSequenceDictionary;
    }
}

