/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.Log;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ngs.Alignment;
import ngs.AlignmentIterator;
import ngs.ErrorMsg;
import ngs.Read;
import ngs.ReadCollection;
import ngs.ReadIterator;

public class SRALazyRecord
extends SAMRecord {
    private static final Log log = Log.getInstance(SRALazyRecord.class);
    private SRAAccession accession;
    private boolean isAligned;
    private transient ReadCollection run;
    private transient Alignment alignmentIterator;
    private transient Read unalignmentIterator;
    private String sraReadId;
    private String sraAlignmentId;
    private int unalignedReadFragmentIndex = -1;
    private Set<LazyField> initializedFields = EnumSet.noneOf(LazyField.class);
    private Set<LazyFlag> initializedFlags = EnumSet.noneOf(LazyFlag.class);
    private Set<LazyAttribute> initializedAttributes = EnumSet.noneOf(LazyAttribute.class);
    private static Map<Short, LazyAttribute> lazyAttributeTags = new HashMap<Short, LazyAttribute>();

    public SRALazyRecord(SAMFileHeader sAMFileHeader, SRAAccession sRAAccession, ReadCollection readCollection, AlignmentIterator alignmentIterator, String string, String string2) {
        this(sAMFileHeader, sRAAccession, string, string2);
        this.run = readCollection;
        this.alignmentIterator = alignmentIterator;
    }

    public SRALazyRecord(SAMFileHeader sAMFileHeader, SRAAccession sRAAccession, ReadCollection readCollection, ReadIterator readIterator, String string, int n) {
        this(sAMFileHeader, sRAAccession, string, n);
        this.run = readCollection;
        this.unalignmentIterator = readIterator;
    }

    protected SRALazyRecord(SAMFileHeader sAMFileHeader, SRAAccession sRAAccession, String string, String string2) {
        this(sAMFileHeader, sRAAccession, string, true);
        this.sraAlignmentId = string2;
    }

    protected SRALazyRecord(SAMFileHeader sAMFileHeader, SRAAccession sRAAccession, String string, int n) {
        this(sAMFileHeader, sRAAccession, string, false);
        this.unalignedReadFragmentIndex = n;
    }

    private SRALazyRecord(SAMFileHeader sAMFileHeader, SRAAccession sRAAccession, String string, boolean bl) {
        super(sAMFileHeader);
        this.accession = sRAAccession;
        this.isAligned = bl;
        this.sraReadId = string;
        this.setReadName(string);
        this.setReadUnmappedFlag(!bl);
    }

    public void detachFromIterator() {
        this.alignmentIterator = null;
        this.unalignmentIterator = null;
    }

    @Override
    public int getAlignmentStart() {
        if (!this.initializedFields.contains((Object)LazyField.ALIGNMENT_START)) {
            this.setAlignmentStart(this.getAlignmentStartImpl());
        }
        return super.getAlignmentStart();
    }

    @Override
    public void setAlignmentStart(int n) {
        if (!this.initializedFields.contains((Object)LazyField.ALIGNMENT_START)) {
            this.initializedFields.add(LazyField.ALIGNMENT_START);
        }
        super.setAlignmentStart(n);
    }

    @Override
    public int getMappingQuality() {
        if (!this.initializedFields.contains((Object)LazyField.MAPPING_QUALITY)) {
            this.setMappingQuality(this.getMappingQualityImpl());
        }
        return super.getMappingQuality();
    }

    @Override
    public void setMappingQuality(int n) {
        if (!this.initializedFields.contains((Object)LazyField.MAPPING_QUALITY)) {
            this.initializedFields.add(LazyField.MAPPING_QUALITY);
        }
        super.setMappingQuality(n);
    }

    @Override
    public String getReferenceName() {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.setReferenceName(this.getReferenceNameImpl());
        }
        return super.getReferenceName();
    }

    @Override
    public void setReferenceName(String string) {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.REFERENCE_NAME);
        }
        super.setReferenceName(string);
    }

    @Override
    public Integer getReferenceIndex() {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.setReferenceName(this.getReferenceNameImpl());
        }
        return super.getReferenceIndex();
    }

    @Override
    public void setReferenceIndex(int n) {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.REFERENCE_NAME);
        }
        super.setReferenceIndex(n);
    }

    @Override
    public String getCigarString() {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.setCigarString(this.getCigarStringImpl());
        }
        return super.getCigarString();
    }

    @Override
    public void setCigarString(String string) {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.initializedFields.add(LazyField.CIGAR_STRING);
        }
        super.setCigarString(string);
    }

    @Override
    public Cigar getCigar() {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.setCigarString(this.getCigarStringImpl());
        }
        return super.getCigar();
    }

    @Override
    public void setCigar(Cigar cigar) {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.initializedFields.add(LazyField.CIGAR_STRING);
        }
        super.setCigar(cigar);
    }

    @Override
    public byte[] getReadBases() {
        if (!this.initializedFields.contains((Object)LazyField.BASES)) {
            this.setReadBases(this.getReadBasesImpl());
        }
        return super.getReadBases();
    }

    @Override
    public void setReadBases(byte[] byArray) {
        if (!this.initializedFields.contains((Object)LazyField.BASES)) {
            this.initializedFields.add(LazyField.BASES);
        }
        super.setReadBases(byArray);
    }

    @Override
    public byte[] getBaseQualities() {
        if (!this.initializedFields.contains((Object)LazyField.QUALS)) {
            this.setBaseQualities(this.getBaseQualitiesImpl());
        }
        return super.getBaseQualities();
    }

    @Override
    public void setBaseQualities(byte[] byArray) {
        if (!this.initializedFields.contains((Object)LazyField.QUALS)) {
            this.initializedFields.add(LazyField.QUALS);
        }
        super.setBaseQualities(byArray);
    }

    @Override
    public int getMateAlignmentStart() {
        if (!this.initializedFields.contains((Object)LazyField.MATE_ALIGNMENT_START)) {
            this.setMateAlignmentStart(this.getMateAlignmentStartImpl());
        }
        return super.getMateAlignmentStart();
    }

    @Override
    public void setMateAlignmentStart(int n) {
        if (!this.initializedFields.contains((Object)LazyField.MATE_ALIGNMENT_START)) {
            this.initializedFields.add(LazyField.MATE_ALIGNMENT_START);
        }
        super.setMateAlignmentStart(n);
    }

    @Override
    public String getMateReferenceName() {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.setMateReferenceName(this.getMateReferenceNameImpl());
        }
        return super.getMateReferenceName();
    }

    @Override
    public void setMateReferenceName(String string) {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.MATE_REFERENCE_NAME);
        }
        super.setMateReferenceName(string);
    }

    @Override
    public Integer getMateReferenceIndex() {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.setMateReferenceName(this.getMateReferenceNameImpl());
        }
        return super.getMateReferenceIndex();
    }

    @Override
    public void setMateReferenceIndex(int n) {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.MATE_REFERENCE_NAME);
        }
        super.setMateReferenceIndex(n);
    }

    @Override
    public int getInferredInsertSize() {
        if (!this.initializedFields.contains((Object)LazyField.INFERRED_INSERT_SIZE)) {
            this.setInferredInsertSize(this.getInferredInsertSizeImpl());
        }
        return super.getInferredInsertSize();
    }

    @Override
    public void setInferredInsertSize(int n) {
        if (!this.initializedFields.contains((Object)LazyField.INFERRED_INSERT_SIZE)) {
            this.initializedFields.add(LazyField.INFERRED_INSERT_SIZE);
        }
        super.setInferredInsertSize(n);
    }

    @Override
    public int getFlags() {
        for (LazyFlag lazyFlag : LazyFlag.values()) {
            if (this.initializedFlags.contains((Object)lazyFlag) || !lazyFlag.canCallOnNotPaired() && !this.getReadPairedFlag()) continue;
            lazyFlag.getFlag(this);
        }
        return super.getFlags();
    }

    @Override
    public void setFlags(int n) {
        for (LazyFlag lazyFlag : LazyFlag.values()) {
            if (this.initializedFlags.contains((Object)lazyFlag)) continue;
            this.initializedFlags.add(lazyFlag);
        }
        super.setFlags(n);
    }

    @Override
    public boolean getReadNegativeStrandFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_NEGATIVE_STRAND)) {
            this.setReadNegativeStrandFlag(this.getReadNegativeStrandFlagImpl());
        }
        return super.getReadNegativeStrandFlag();
    }

    @Override
    public void setReadNegativeStrandFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_NEGATIVE_STRAND)) {
            this.initializedFlags.add(LazyFlag.READ_NEGATIVE_STRAND);
        }
        super.setReadNegativeStrandFlag(bl);
    }

    @Override
    public boolean getReadPairedFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_PAIRED)) {
            this.setReadPairedFlag(this.getReadPairedFlagImpl());
        }
        return super.getReadPairedFlag();
    }

    @Override
    public void setReadPairedFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_PAIRED)) {
            this.initializedFlags.add(LazyFlag.READ_PAIRED);
        }
        super.setReadPairedFlag(bl);
    }

    @Override
    public boolean getProperPairFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.PROPER_PAIR)) {
            this.setProperPairFlag(this.getProperPairFlagImpl());
        }
        return super.getProperPairFlag();
    }

    @Override
    public void setProperPairFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.PROPER_PAIR)) {
            this.initializedFlags.add(LazyFlag.PROPER_PAIR);
        }
        super.setProperPairFlag(bl);
    }

    @Override
    public boolean getNotPrimaryAlignmentFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.NOT_PRIMARY_ALIGNMENT)) {
            this.setNotPrimaryAlignmentFlag(this.getNotPrimaryAlignmentFlagImpl());
        }
        return super.getNotPrimaryAlignmentFlag();
    }

    @Override
    public void setNotPrimaryAlignmentFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.NOT_PRIMARY_ALIGNMENT)) {
            this.initializedFlags.add(LazyFlag.NOT_PRIMARY_ALIGNMENT);
        }
        super.setNotPrimaryAlignmentFlag(bl);
    }

    @Override
    public boolean getMateNegativeStrandFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_NEGATIVE_STRAND)) {
            this.setMateNegativeStrandFlag(this.getMateNegativeStrandFlagImpl());
        }
        return super.getMateNegativeStrandFlag();
    }

    @Override
    public void setMateNegativeStrandFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_NEGATIVE_STRAND)) {
            this.initializedFlags.add(LazyFlag.MATE_NEGATIVE_STRAND);
        }
        super.setMateNegativeStrandFlag(bl);
    }

    @Override
    public boolean getMateUnmappedFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_UNMAPPED)) {
            this.setMateUnmappedFlag(this.getMateUnmappedFlagImpl());
        }
        return super.getMateUnmappedFlag();
    }

    @Override
    public void setMateUnmappedFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_UNMAPPED)) {
            this.initializedFlags.add(LazyFlag.MATE_UNMAPPED);
        }
        super.setMateUnmappedFlag(bl);
    }

    @Override
    public boolean getFirstOfPairFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.FIRST_OF_PAIR)) {
            this.setFirstOfPairFlag(this.getFirstOfPairFlagImpl());
        }
        return super.getFirstOfPairFlag();
    }

    @Override
    public void setFirstOfPairFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.FIRST_OF_PAIR)) {
            this.initializedFlags.add(LazyFlag.FIRST_OF_PAIR);
        }
        super.setFirstOfPairFlag(bl);
    }

    @Override
    public boolean getSecondOfPairFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.SECOND_OF_PAIR)) {
            this.setSecondOfPairFlag(this.getSecondOfPairFlagImpl());
        }
        return super.getSecondOfPairFlag();
    }

    @Override
    public void setSecondOfPairFlag(boolean bl) {
        if (!this.initializedFlags.contains((Object)LazyFlag.SECOND_OF_PAIR)) {
            this.initializedFlags.add(LazyFlag.SECOND_OF_PAIR);
        }
        super.setSecondOfPairFlag(bl);
    }

    @Override
    public Object getAttribute(short s) {
        LazyAttribute lazyAttribute = lazyAttributeTags.get(s);
        if (lazyAttribute != null && !this.initializedAttributes.contains((Object)lazyAttribute)) {
            this.setAttribute(s, (Object)lazyAttribute.getAttribute(this));
        }
        return super.getAttribute(s);
    }

    @Override
    public void setAttribute(short s, Object object) {
        LazyAttribute lazyAttribute = lazyAttributeTags.get(s);
        if (lazyAttribute != null && !this.initializedAttributes.contains((Object)lazyAttribute)) {
            this.initializedAttributes.add(lazyAttribute);
        }
        super.setAttribute(s, object);
    }

    @Override
    protected void setAttribute(short s, Object object, boolean bl) {
        LazyAttribute lazyAttribute = lazyAttributeTags.get(s);
        if (lazyAttribute != null && !this.initializedAttributes.contains((Object)lazyAttribute)) {
            this.initializedAttributes.add(lazyAttribute);
        }
        super.setAttribute(s, object, bl);
    }

    @Override
    public void clearAttributes() {
        for (LazyAttribute lazyAttribute : LazyAttribute.values()) {
            if (this.initializedAttributes.contains((Object)lazyAttribute)) continue;
            this.initializedAttributes.add(lazyAttribute);
        }
        super.clearAttributes();
    }

    @Override
    protected void setAttributes(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        for (LazyAttribute lazyAttribute : LazyAttribute.values()) {
            if (this.initializedAttributes.contains((Object)lazyAttribute)) continue;
            this.initializedAttributes.add(lazyAttribute);
        }
        super.setAttributes(sAMBinaryTagAndValue);
    }

    @Override
    protected SAMBinaryTagAndValue getBinaryAttributes() {
        for (Map.Entry<Short, LazyAttribute> entry : lazyAttributeTags.entrySet()) {
            if (this.initializedAttributes.contains((Object)entry.getValue())) continue;
            this.getAttribute(entry.getKey());
        }
        return super.getBinaryAttributes();
    }

    @Override
    public boolean isUnsignedArrayAttribute(String string) {
        Short s = SAMTagUtil.getSingleton().makeBinaryTag(string);
        LazyAttribute lazyAttribute = lazyAttributeTags.get(s);
        if (lazyAttribute != null && !this.initializedAttributes.contains((Object)lazyAttribute)) {
            this.getAttribute(s);
        }
        return super.isUnsignedArrayAttribute(string);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SRALazyRecord) {
            SRALazyRecord sRALazyRecord = (SRALazyRecord)object;
            sRALazyRecord.getReferenceIndex();
            sRALazyRecord.getAlignmentStart();
        }
        this.getReferenceIndex();
        this.getAlignmentStart();
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        this.getReferenceIndex();
        this.getAlignmentStart();
        return super.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SRALazyRecord sRALazyRecord = (SRALazyRecord)super.clone();
        sRALazyRecord.initializedFields = EnumSet.copyOf(this.initializedFields);
        sRALazyRecord.initializedFlags = EnumSet.copyOf(this.initializedFlags);
        sRALazyRecord.initializedAttributes = EnumSet.copyOf(this.initializedAttributes);
        sRALazyRecord.detachFromIterator();
        return sRALazyRecord;
    }

    @Override
    public String format() {
        if (!this.initializedAttributes.contains((Object)LazyAttribute.RG)) {
            this.getAttribute("RG");
        }
        return super.format();
    }

    @Override
    public List<SAMValidationError> isValid(boolean bl) {
        this.loadFields();
        this.getFlags();
        this.getBinaryAttributes();
        return super.isValid(bl);
    }

    private ReadCollection getReadCollection() {
        if (this.run != null) {
            return this.run;
        }
        log.debug("Recovering SRA read collection. Accession: " + this.accession);
        try {
            this.run = NGS.openReadCollection((String)this.accession.toString());
            return this.run;
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private Alignment getCurrentAlignment() throws ErrorMsg {
        if (!this.isAligned) {
            throw new RuntimeException("Should be called for aligned records only");
        }
        if (this.alignmentIterator == null) {
            log.debug("Recovering SAM record after detaching from iterator. Alignment id: " + this.sraAlignmentId);
            if (this.sraAlignmentId == null) {
                throw new RuntimeException("Cannot recover SAM object after detaching from iterator: no alignment id");
            }
            this.alignmentIterator = this.getReadCollection().getAlignment(this.sraAlignmentId);
        }
        return this.alignmentIterator;
    }

    private Read getCurrentUnalignedRead() throws ErrorMsg {
        if (this.isAligned) {
            throw new RuntimeException("Should be called for unaligned records only");
        }
        if (this.unalignmentIterator == null) {
            log.debug("Recovering SAM record after detaching from iterator. Read id: " + this.sraReadId + ", fragment index: " + this.unalignedReadFragmentIndex);
            if (this.sraReadId == null) {
                throw new RuntimeException("Cannot recover SAM object after detaching from iterator: no read id");
            }
            Read read = this.getReadCollection().getRead(this.sraReadId);
            for (int i = 0; i < this.unalignedReadFragmentIndex + 1; ++i) {
                read.nextFragment();
            }
            this.unalignmentIterator = read;
        }
        return this.unalignmentIterator;
    }

    private void loadFields() {
        for (LazyField lazyField : LazyField.values()) {
            if (this.initializedFields.contains((Object)lazyField)) continue;
            lazyField.loadValue(this);
        }
    }

    private int getAlignmentStartImpl() {
        try {
            if (this.isAligned) {
                return (int)this.getCurrentAlignment().getAlignmentPosition() + 1;
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return 0;
    }

    private int getMappingQualityImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getMappingQuality();
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return 0;
    }

    private String getReferenceNameImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getReferenceSpec();
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return "*";
    }

    private String getCigarStringImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getShortCigar(false);
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return "*";
    }

    private byte[] getReadBasesImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getAlignedFragmentBases().getBytes();
            }
            return this.getCurrentUnalignedRead().getFragmentBases().getBytes();
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private byte[] getBaseQualitiesImpl() {
        try {
            Object object = this.isAligned ? this.getCurrentAlignment() : this.getCurrentUnalignedRead();
            return SAMUtils.fastqToPhred(object.getFragmentQualities());
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private int getMateAlignmentStartImpl() {
        try {
            if (this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag()) {
                Alignment alignment = this.getCurrentAlignment().getMateAlignment();
                return (int)alignment.getAlignmentPosition() + 1;
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return 0;
    }

    private String getMateReferenceNameImpl() {
        try {
            if (this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag()) {
                return this.getCurrentAlignment().getMateReferenceSpec();
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return "*";
    }

    private int getInferredInsertSizeImpl() {
        try {
            if (this.isAligned) {
                return (int)this.getCurrentAlignment().getTemplateLength();
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return 0;
    }

    private boolean getReadNegativeStrandFlagImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getIsReversedOrientation();
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return false;
    }

    private boolean getReadPairedFlagImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().isPaired();
            }
            return this.getCurrentUnalignedRead().getNumFragments() > 1;
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private boolean getProperPairFlagImpl() {
        return this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag();
    }

    private boolean getNotPrimaryAlignmentFlagImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getAlignmentCategory() == 2;
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return false;
    }

    private boolean getMateNegativeStrandFlagImpl() {
        try {
            if (this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag()) {
                Alignment alignment = this.getCurrentAlignment().getMateAlignment();
                return alignment.getIsReversedOrientation();
            }
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        return false;
    }

    private boolean getMateUnmappedFlagImpl() {
        try {
            if (this.isAligned) {
                return !this.getCurrentAlignment().hasMate();
            }
            int n = this.unalignedReadFragmentIndex + 1;
            Read read = this.getCurrentUnalignedRead();
            int n2 = read.getNumFragments();
            if (n == n2) {
                n = 0;
            }
            return read.fragmentIsAligned(n);
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private boolean getFirstOfPairFlagImpl() {
        if (!this.getReadPairedFlag()) {
            return false;
        }
        try {
            if (this.isAligned) {
                String string = this.getCurrentAlignment().getFragmentId();
                if (!string.contains(".FA")) {
                    throw new RuntimeException("Invalid fragment id: " + string);
                }
                return string.contains(".FA0.");
            }
            return this.unalignedReadFragmentIndex == 0;
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private boolean getSecondOfPairFlagImpl() {
        if (!this.getReadPairedFlag()) {
            return false;
        }
        try {
            if (this.isAligned) {
                String string = this.getCurrentAlignment().getFragmentId();
                if (!string.contains(".FA")) {
                    throw new RuntimeException("Invalid fragment id: " + string);
                }
                return !string.contains(".FA0.");
            }
            return this.unalignedReadFragmentIndex != 0;
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    private String getAttributeGroupNameImpl() {
        try {
            String string = this.isAligned ? this.getCurrentAlignment().getReadGroup() : this.getCurrentUnalignedRead().getReadGroup();
            if (!string.isEmpty()) {
                return string;
            }
            return this.getReadCollection().getName();
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
    }

    static {
        lazyAttributeTags.put(SAMTagUtil.getSingleton().RG, LazyAttribute.RG);
    }

    private static enum LazyAttribute {
        RG{

            @Override
            public String getAttribute(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getAttributeGroupNameImpl();
            }
        };


        public abstract String getAttribute(SRALazyRecord var1);
    }

    private static enum LazyFlag {
        READ_NEGATIVE_STRAND(true){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getReadNegativeStrandFlag();
            }
        }
        ,
        READ_PAIRED(true){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getReadPairedFlag();
            }
        }
        ,
        PROPER_PAIR(false){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getProperPairFlag();
            }
        }
        ,
        NOT_PRIMARY_ALIGNMENT(true){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getNotPrimaryAlignmentFlag();
            }
        }
        ,
        MATE_NEGATIVE_STRAND(false){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getMateNegativeStrandFlag();
            }
        }
        ,
        MATE_UNMAPPED(false){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getMateUnmappedFlag();
            }
        }
        ,
        FIRST_OF_PAIR(false){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getFirstOfPairFlag();
            }
        }
        ,
        SECOND_OF_PAIR(false){

            @Override
            public boolean getFlag(SRALazyRecord sRALazyRecord) {
                return sRALazyRecord.getSecondOfPairFlag();
            }
        };

        private final boolean canCallOnNotPaired;

        private LazyFlag(boolean bl) {
            this.canCallOnNotPaired = bl;
        }

        public boolean canCallOnNotPaired() {
            return this.canCallOnNotPaired;
        }

        public abstract boolean getFlag(SRALazyRecord var1);
    }

    private static enum LazyField {
        ALIGNMENT_START{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getAlignmentStart();
            }
        }
        ,
        MAPPING_QUALITY{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getMappingQuality();
            }
        }
        ,
        REFERENCE_NAME{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getReferenceName();
            }
        }
        ,
        CIGAR_STRING{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getCigarString();
            }
        }
        ,
        BASES{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getReadBases();
            }
        }
        ,
        QUALS{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getBaseQualities();
            }
        }
        ,
        MATE_ALIGNMENT_START{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getMateAlignmentStart();
            }
        }
        ,
        MATE_REFERENCE_NAME{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getMateReferenceName();
            }
        }
        ,
        INFERRED_INSERT_SIZE{

            @Override
            public void loadValue(SRALazyRecord sRALazyRecord) {
                sRALazyRecord.getInferredInsertSize();
            }
        };


        public abstract void loadValue(SRALazyRecord var1);
    }
}

