/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.TempStreamFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class DiskBackedQueue<E>
implements Queue<E> {
    private final int maxRecordsInRamQueue;
    private final Queue<E> ramRecords;
    private File diskRecords = null;
    private final TempStreamFactory tempStreamFactory = new TempStreamFactory();
    private OutputStream outputStream = null;
    private InputStream inputStream = null;
    private boolean canAdd = true;
    private int numRecordsOnDisk = 0;
    private E headRecord = null;
    private final List<File> tmpDirs;
    private final SortingCollection.Codec<E> codec;

    private DiskBackedQueue(SortingCollection.Codec<E> codec, int n, List<File> list) {
        if (n < 0) {
            throw new IllegalArgumentException("maxRecordsInRamQueue must be >= 0");
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("At least one temp directory must be provided.");
        }
        for (File file : list) {
            IOUtil.assertDirectoryIsWritable(file);
        }
        this.tmpDirs = list;
        this.codec = codec;
        this.maxRecordsInRamQueue = n == 0 ? 0 : n - 1;
        this.ramRecords = new ArrayDeque(this.maxRecordsInRamQueue);
    }

    public static <T> DiskBackedQueue<T> newInstance(SortingCollection.Codec<T> codec, int n, List<File> list) {
        return new DiskBackedQueue<T>(codec, n, list);
    }

    public boolean canAdd() {
        return this.canAdd;
    }

    public int getNumRecordsOnDisk() {
        return this.numRecordsOnDisk;
    }

    public boolean headRecordIsFromDisk() {
        return !this.canAdd;
    }

    @Override
    public boolean add(E e) throws IllegalStateException {
        if (!this.canAdd) {
            throw new IllegalStateException("Cannot add to DiskBackedQueue whose canAdd() method returns false");
        }
        if (this.headRecord == null) {
            if (0 < this.numRecordsOnDisk) {
                throw new SAMException("Head record was null but we have records on disk. Bug!");
            }
            this.headRecord = e;
        } else if (this.ramRecords.size() == this.maxRecordsInRamQueue) {
            this.spillToDisk(e);
        } else {
            if (0 < this.numRecordsOnDisk) {
                throw new SAMException("Trying to add records to RAM but there were records on disk. Bug!");
            }
            this.ramRecords.add(e);
        }
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.canAdd && this.add(e);
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (e == null) {
            throw new NoSuchElementException("Attempting to remove() from empty DiskBackedQueue");
        }
        return e;
    }

    @Override
    public E poll() {
        E e = this.headRecord;
        if (e != null) {
            this.updateQueueHead();
        }
        return e;
    }

    @Override
    public E element() {
        if (this.headRecord != null) {
            return this.headRecord;
        }
        throw new NoSuchElementException("Attempting to element() from empty DiskBackedQueue");
    }

    @Override
    public E peek() {
        return this.headRecord;
    }

    @Override
    public int size() {
        return this.headRecord == null ? 0 : 1 + this.ramRecords.size() + this.numRecordsOnDisk;
    }

    @Override
    public boolean isEmpty() {
        return this.headRecord == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        try {
            for (E e : collection) {
                this.add(e);
            }
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Cannot add to DiskBackedQueue whose canAdd() method returns false", illegalStateException);
        }
    }

    @Override
    public void clear() {
        this.headRecord = null;
        this.ramRecords.clear();
        this.closeIOResources();
        this.outputStream = null;
        this.inputStream = null;
        this.diskRecords = null;
        this.canAdd = true;
    }

    protected void finalize() throws Throwable {
        this.closeIOResources();
        super.finalize();
    }

    private void spillToDisk(E e) throws RuntimeIOException {
        try {
            if (this.diskRecords == null) {
                this.diskRecords = this.newTempFile();
                this.outputStream = this.tempStreamFactory.wrapTempOutputStream(new FileOutputStream(this.diskRecords), Defaults.BUFFER_SIZE);
                this.codec.setOutputStream(this.outputStream);
            }
            this.codec.encode(e);
            this.outputStream.flush();
            ++this.numRecordsOnDisk;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Problem writing temporary file. Try setting TMP_DIR to a file system with lots of space.", iOException);
        }
    }

    private File newTempFile() throws IOException {
        return IOUtil.newTempFile("diskbackedqueue.", ".tmp", this.tmpDirs.toArray(new File[this.tmpDirs.size()]), 0x140000000L);
    }

    private void updateQueueHead() {
        if (!this.ramRecords.isEmpty()) {
            this.headRecord = this.ramRecords.poll();
            if (0 < this.numRecordsOnDisk) {
                this.canAdd = false;
            }
        } else if (this.diskRecords != null) {
            this.headRecord = this.readFileRecord(this.diskRecords);
            this.canAdd = false;
        } else {
            this.canAdd = true;
            this.headRecord = null;
        }
    }

    private E readFileRecord(File file) {
        if (this.canAdd) {
            this.canAdd = false;
        }
        if (file == null) {
            throw new IllegalStateException("The file to read from was null");
        }
        try {
            E e;
            if (this.inputStream == null) {
                this.inputStream = new FileInputStream(file);
                this.codec.setInputStream(this.tempStreamFactory.wrapTempInputStream(this.inputStream, Defaults.BUFFER_SIZE));
            }
            if ((e = this.codec.decode()) != null) {
                --this.numRecordsOnDisk;
            }
            return e;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("DiskBackedQueue encountered an error reading from a file", iOException);
        }
    }

    private void closeIOResources() {
        CloserUtil.close(this.outputStream);
        CloserUtil.close(this.inputStream);
        if (this.diskRecords != null) {
            IOUtil.deleteFiles(this.diskRecords);
        }
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support remove(Object o)");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support removeAll(Collection<?> c)");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support retainAll(Collection<?> c)");
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support contains(Object o)");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support containsAll(Collection<?> c)");
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("DiskBackedQueue does not support iterator()");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("DiskBackedQueue does not support toArray()");
    }

    @Override
    public <T1> T1[] toArray(T1[] T1Array) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support toArray(T1[] a)");
    }
}

