/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.DiskBackedQueue;
import htsjdk.samtools.util.SamRecordWithOrdinal;
import java.io.File;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;

public class SamRecordTrackingBuffer<T extends SamRecordWithOrdinal> {
    private int availableRecordsInMemory;
    private final int blockSize;
    private final List<File> tmpDirs;
    private long queueHeadRecordIndex;
    private long queueTailRecordIndex;
    private final Deque<BufferBlock> blocks;
    private final SAMFileHeader header;
    private final Class<T> clazz;

    public SamRecordTrackingBuffer(int n, int n2, List<File> list, SAMFileHeader sAMFileHeader, Class<T> clazz) {
        this.availableRecordsInMemory = n;
        this.blockSize = n2;
        this.tmpDirs = list;
        this.queueHeadRecordIndex = -1L;
        this.queueTailRecordIndex = -1L;
        this.blocks = new ArrayDeque<BufferBlock>();
        this.header = sAMFileHeader;
        this.clazz = clazz;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty() || this.blocks.getFirst().isEmpty();
    }

    public boolean canEmit() {
        return !this.blocks.isEmpty() && this.blocks.getFirst().canEmit();
    }

    public void add(SamRecordWithOrdinal samRecordWithOrdinal) {
        if (this.isEmpty()) {
            this.queueHeadRecordIndex = samRecordWithOrdinal.getRecordOrdinal();
            this.queueTailRecordIndex = samRecordWithOrdinal.getRecordOrdinal() - 1L;
        }
        ++this.queueTailRecordIndex;
        if (samRecordWithOrdinal.getRecordOrdinal() != this.queueTailRecordIndex) {
            throw new SAMException("The records were added out of order");
        }
        if (this.blocks.isEmpty() || !this.blocks.getLast().canAdd()) {
            int n = Math.min(this.blockSize, this.availableRecordsInMemory);
            this.availableRecordsInMemory -= n;
            BufferBlock bufferBlock = new BufferBlock(this.blockSize, n, this.tmpDirs, this.header, samRecordWithOrdinal.getRecordOrdinal());
            this.blocks.addLast(bufferBlock);
        }
        this.blocks.getLast().add(samRecordWithOrdinal);
    }

    public SamRecordWithOrdinal next() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Attempting to remove an element from an empty SamRecordTrackingBuffer");
        }
        BufferBlock bufferBlock = this.blocks.getFirst();
        if (!bufferBlock.canEmit()) {
            throw new SAMException("Attempting to get a samRecordWithOrdinal from the SamRecordTrackingBuffer that has not been through marked as examined. canEmit() must return true in order to call next()");
        }
        if (!bufferBlock.headRecordIsFromDisk()) {
            ++this.availableRecordsInMemory;
        }
        SamRecordWithOrdinal samRecordWithOrdinal = bufferBlock.next();
        if (bufferBlock.hasBeenDrained()) {
            this.blocks.poll();
            bufferBlock.clear();
        }
        ++this.queueHeadRecordIndex;
        return samRecordWithOrdinal;
    }

    public void remove() {
        this.next();
    }

    public long size() {
        return this.queueTailRecordIndex - this.queueHeadRecordIndex + 1L;
    }

    private BufferBlock getBlock(SamRecordWithOrdinal samRecordWithOrdinal) {
        for (BufferBlock bufferBlock : this.blocks) {
            if (bufferBlock.getStartIndex() > samRecordWithOrdinal.getRecordOrdinal() || bufferBlock.getEndIndex() < samRecordWithOrdinal.getRecordOrdinal()) continue;
            return bufferBlock;
        }
        return null;
    }

    public boolean contains(SamRecordWithOrdinal samRecordWithOrdinal) {
        return null != this.getBlock(samRecordWithOrdinal);
    }

    public void setResultState(SamRecordWithOrdinal samRecordWithOrdinal, boolean bl) {
        BufferBlock bufferBlock = this.getBlock(samRecordWithOrdinal);
        if (null == bufferBlock) {
            throw new SAMException("Attempted to set examined information on a samRecordWithOrdinal whose index is not found in the SamRecordTrackingBuffer. recordIndex: " + samRecordWithOrdinal.getRecordOrdinal());
        }
        bufferBlock.setResultState(samRecordWithOrdinal, bl);
    }

    public void close() {
        while (!this.blocks.isEmpty()) {
            BufferBlock bufferBlock = this.blocks.pollFirst();
            bufferBlock.clear();
        }
    }

    private class BufferBlock {
        private final DiskBackedQueue<SAMRecord> recordsQueue;
        private final int maxBlockSize;
        private long currentStartIndex;
        private final long originalStartIndex;
        private long endIndex;
        private final BitSet wasExaminedIndexes;
        private final BitSet resultStateIndexes;

        public BufferBlock(int n, int n2, List<File> list, SAMFileHeader sAMFileHeader, long l) {
            this.recordsQueue = DiskBackedQueue.newInstance(new BAMRecordCodec(sAMFileHeader), n2, list);
            this.maxBlockSize = n;
            this.currentStartIndex = 0L;
            this.endIndex = -1L;
            this.wasExaminedIndexes = new BitSet(n);
            this.resultStateIndexes = new BitSet(n);
            this.originalStartIndex = l;
        }

        public boolean canAdd() {
            return this.endIndex - this.originalStartIndex + 1L < (long)this.maxBlockSize && this.recordsQueue.canAdd();
        }

        public boolean headRecordIsFromDisk() {
            return this.recordsQueue.headRecordIsFromDisk();
        }

        public boolean hasBeenDrained() {
            long l = this.canAdd() ? this.originalStartIndex + (long)this.maxBlockSize : this.endIndex;
            return this.currentStartIndex > l;
        }

        public long getStartIndex() {
            return this.currentStartIndex;
        }

        public long getEndIndex() {
            return this.endIndex;
        }

        public void add(SamRecordWithOrdinal samRecordWithOrdinal) {
            if (this.recordsQueue.canAdd()) {
                if (this.recordsQueue.isEmpty()) {
                    this.currentStartIndex = samRecordWithOrdinal.getRecordOrdinal();
                    this.endIndex = samRecordWithOrdinal.getRecordOrdinal() - 1L;
                }
                this.recordsQueue.add(samRecordWithOrdinal.getRecord());
                ++this.endIndex;
            } else {
                throw new IllegalStateException("Cannot add to DiskBackedQueue whose canAdd() method returns false");
            }
        }

        private int ensureIndexFitsInAnInt(long l) {
            if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
                throw new SAMException("Error: index out of range: " + l);
            }
            return (int)l;
        }

        public void setResultState(SamRecordWithOrdinal samRecordWithOrdinal, boolean bl) {
            this.wasExaminedIndexes.set(this.ensureIndexFitsInAnInt(samRecordWithOrdinal.getRecordOrdinal() - this.originalStartIndex), true);
            this.resultStateIndexes.set(this.ensureIndexFitsInAnInt(samRecordWithOrdinal.getRecordOrdinal() - this.originalStartIndex), bl);
        }

        public boolean isEmpty() {
            return this.recordsQueue.isEmpty();
        }

        public boolean canEmit() {
            return this.wasExaminedIndexes.get(this.ensureIndexFitsInAnInt(this.currentStartIndex - this.originalStartIndex));
        }

        public SamRecordWithOrdinal next() throws IllegalStateException {
            if (this.canEmit()) {
                try {
                    SamRecordWithOrdinal samRecordWithOrdinal = (SamRecordWithOrdinal)SamRecordTrackingBuffer.this.clazz.newInstance();
                    samRecordWithOrdinal.setRecord(this.recordsQueue.poll());
                    samRecordWithOrdinal.setRecordOrdinal(this.currentStartIndex);
                    samRecordWithOrdinal.setResultState(this.resultStateIndexes.get(this.ensureIndexFitsInAnInt(this.currentStartIndex - this.originalStartIndex)));
                    ++this.currentStartIndex;
                    return samRecordWithOrdinal;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            throw new IllegalStateException("Cannot call next() on a buffer block where canEmit() is false!");
        }

        public void remove() {
            this.next();
        }

        public long size() {
            return this.endIndex - this.currentStartIndex + 1L;
        }

        public void clear() {
            this.recordsQueue.clear();
        }
    }
}

