/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.zip;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.zip.ZStreamRef;
import java.io.File;
import java.net.URL;
import java.util.zip.Deflater;

public class IntelDeflater
extends Deflater {
    private final ZStreamRef zsRef;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;

    public IntelDeflater(int n, boolean bl) {
        this.level = n;
        this.strategy = 0;
        this.zsRef = new ZStreamRef(IntelDeflater.init(n, 0, bl));
    }

    public IntelDeflater(int n) {
        this(n, false);
    }

    public IntelDeflater() {
        this(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInput(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.buf = byArray;
            this.off = n;
            this.len = n2;
        }
    }

    @Override
    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDictionary(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            IntelDeflater.setDictionary(this.zsRef.address(), byArray, n, n2);
        }
    }

    @Override
    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStrategy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            if (this.strategy != n) {
                this.strategy = n;
                this.setParams = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(int n) {
        if ((n < 0 || n > 9) && n != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            if (this.level != n) {
                this.level = n;
                this.setParams = true;
            }
        }
    }

    @Override
    public boolean needsInput() {
        return this.len <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.finish = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finished() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.finished;
        }
    }

    @Override
    public int deflate(byte[] byArray, int n, int n2) {
        return this.deflate(byArray, n, n2, 0);
    }

    @Override
    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length, 0);
    }

    @Override
    public int deflate(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            if (n3 == 0 || n3 == 2 || n3 == 3) {
                return this.deflateBytes(this.zsRef.address(), byArray, n, n2, n3);
            }
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAdler() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return IntelDeflater.getAdler(this.zsRef.address());
        }
    }

    @Override
    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesRead() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return IntelDeflater.getBytesRead(this.zsRef.address());
        }
    }

    @Override
    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesWritten() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return IntelDeflater.getBytesWritten(this.zsRef.address());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            IntelDeflater.reset(this.zsRef.address());
            this.finish = false;
            this.finished = false;
            this.len = 0;
            this.off = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            long l = this.zsRef.address();
            this.zsRef.clear();
            if (l != 0L) {
                IntelDeflater.end(l);
                this.buf = null;
            }
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        assert (Thread.holdsLock(this.zsRef));
        if (this.zsRef.address() == 0L) {
            throw new NullPointerException("IntelDeflater has been closed");
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private static native int getAdler(long var0);

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        try {
            File file;
            if (Defaults.INTEL_DEFLATER_SHARED_LIBRARY_PATH != null) {
                file = new File(Defaults.INTEL_DEFLATER_SHARED_LIBRARY_PATH);
            } else {
                URL uRL = IntelDeflater.class.getProtectionDomain().getCodeSource().getLocation();
                file = new File(new File(uRL.getPath()).getParentFile(), "libIntelDeflater.so");
            }
            System.load(file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            System.loadLibrary("IntelDeflater");
        }
        IntelDeflater.initIDs();
    }
}

