/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.bed;

import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.tribble.bed.SimpleBEDFeature;
import java.util.ArrayList;
import java.util.List;

public class FullBEDFeature
extends SimpleBEDFeature
implements BEDFeature {
    private List<Exon> exons = new ArrayList<Exon>();

    public FullBEDFeature(String string, int n, int n2) {
        super(n, n2, string);
    }

    @Override
    public List<Exon> getExons() {
        return this.exons;
    }

    public void setExons(List<Exon> list) {
        this.exons = list;
    }

    public void addExon(Exon exon) {
        if (exon == null) {
            this.exons = new ArrayList<Exon>();
        }
        this.exons.add(exon);
    }

    public void addExon(int n, int n2, int n3, int n4, int n5) {
        Exon exon = new Exon(n, n2);
        exon.setCodingStart(n3);
        exon.setCodingEnd(n4);
        exon.setNumber(n5);
        this.addExon(exon);
    }

    public class Exon2 {
        private int number;
        private int readingFrame = -1;
        private int start;
        private int end;
        private int codingStart;
        private int codingEnd;
        boolean utr = false;
        private int mrnaBase = -1;

        public Exon2(int n, int n2, int n3, int n4) {
            this.start = n;
            this.end = n2;
            this.codingStart = n3;
            this.codingEnd = n4;
        }

        public void setMrnaBase(int n) {
            this.mrnaBase = n;
        }

        public int getAminoAcidNumber(int n) {
            if (this.mrnaBase < 0) {
                return -1;
            }
            if (n < FullBEDFeature.this.getStart() || n > FullBEDFeature.this.getEnd()) {
                throw new IndexOutOfBoundsException();
            }
            if (FullBEDFeature.this.getStrand() == Strand.POSITIVE) {
                int n2 = this.mrnaBase + (n - this.codingStart) - 1;
                return n2 < 0 ? -1 : n2 / 3 + 1;
            }
            if (FullBEDFeature.this.getStrand() == Strand.NEGATIVE) {
                int n3 = this.mrnaBase + (this.codingEnd - n);
                return n3 < 0 ? -1 : n3 / 3 + 1;
            }
            return 0;
        }

        public void setUTR(boolean bl) {
            this.utr = bl;
            this.codingStart = FullBEDFeature.this.getStrand() == Strand.POSITIVE ? (this.codingEnd = FullBEDFeature.this.getEnd()) : (this.codingEnd = FullBEDFeature.this.getStart());
        }

        public void setCodingStart(int n) {
            this.codingStart = Math.max(FullBEDFeature.this.getStart(), n);
        }

        public void setCodingEnd(int n) {
            this.codingEnd = Math.min(FullBEDFeature.this.getEnd(), n);
        }

        public void setReadingFrame(int n) {
            this.readingFrame = n;
        }

        public void setPhase(int n) {
            if (FullBEDFeature.this.getStrand() == Strand.POSITIVE) {
                this.readingFrame = n;
            } else if (FullBEDFeature.this.getStrand() == Strand.NEGATIVE) {
                int n2;
                this.readingFrame = n2 = (this.getCodingLength() - n) % 3;
            }
        }

        public int getCdStart() {
            return this.codingStart;
        }

        public int getCdEnd() {
            return this.codingEnd;
        }

        public int getCodingLength() {
            return this.utr ? 0 : Math.max(0, this.codingEnd - this.codingStart);
        }

        int getReadingShift() {
            return this.readingFrame;
        }

        public String getValueString(double d) {
            String string = this.number > 0 ? "Exon number: " + this.number : "";
            int n = this.getAminoAcidNumber((int)d);
            if (n > 0) {
                string = string + "<br>Amino acid number: " + n;
            }
            return string;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int n) {
            this.number = n;
        }
    }

    public class Exon {
        int start;
        int end;
        private int number;
        private int readingFrame = -1;
        private int codingStart;
        private int codingEnd;
        boolean utr = false;
        private int mrnaBase = -1;

        public void setMrnaBase(int n) {
            this.mrnaBase = n;
        }

        public Exon(int n, int n2) {
            this.start = n;
            this.end = n2;
            this.codingStart = n;
            this.codingEnd = n2;
        }

        public void setUTR(boolean bl) {
            this.utr = bl;
            this.codingStart = FullBEDFeature.this.strand == Strand.POSITIVE ? (this.codingEnd = this.end) : (this.codingEnd = this.start);
        }

        public void setCodingStart(int n) {
            this.codingStart = Math.max(this.start, n);
        }

        public void setCodingEnd(int n) {
            this.codingEnd = Math.min(this.end, n);
        }

        public void setReadingFrame(int n) {
            this.readingFrame = n;
        }

        public void setPhase(int n) {
            if (FullBEDFeature.this.strand == Strand.POSITIVE) {
                this.readingFrame = n;
            } else if (FullBEDFeature.this.strand == Strand.NEGATIVE) {
                int n2;
                this.readingFrame = n2 = (this.getCodingLength() - n) % 3;
            }
        }

        public int getCdStart() {
            return this.codingStart;
        }

        public int getCdEnd() {
            return this.codingEnd;
        }

        public int getCodingLength() {
            return this.utr ? 0 : Math.max(0, this.codingEnd - this.codingStart + 1);
        }

        int getReadingShift() {
            return this.readingFrame;
        }

        public String getValueString(double d) {
            String string = this.number > 0 ? "Exon number: " + this.number : "";
            return string;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int n) {
            this.number = n;
        }
    }
}

