/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.interval.IntervalIndexCreator;
import htsjdk.tribble.index.linear.LinearIndexCreator;
import htsjdk.tribble.util.MathUtils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class DynamicIndexCreator
extends TribbleIndexCreator {
    IndexFactory.IndexBalanceApproach iba;
    Map<IndexFactory.IndexType, TribbleIndexCreator> creators;
    int longestFeatureLength = 0;
    long featureCount = 0L;
    MathUtils.RunningStat stats = new MathUtils.RunningStat();
    long basesSeen = 0L;
    Feature lastFeature = null;
    File inputFile;

    public DynamicIndexCreator(File file, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        this.iba = indexBalanceApproach;
        this.inputFile = file;
        this.creators = this.getIndexCreators(file, indexBalanceApproach);
    }

    @Override
    public Index finalizeIndex(long l) {
        LinkedHashMap<Double, TribbleIndexCreator> linkedHashMap = DynamicIndexCreator.scoreIndexes((double)this.featureCount / (double)this.basesSeen, this.creators, this.longestFeatureLength, this.iba);
        TribbleIndexCreator tribbleIndexCreator = this.getMinIndex(linkedHashMap, this.iba);
        for (Map.Entry entry : this.properties.entrySet()) {
            tribbleIndexCreator.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        tribbleIndexCreator.addProperty("FEATURE_LENGTH_MEAN", String.valueOf(this.stats.mean()));
        tribbleIndexCreator.addProperty("FEATURE_LENGTH_STD_DEV", String.valueOf(this.stats.standardDeviation()));
        tribbleIndexCreator.addProperty("MEAN_FEATURE_VARIANCE", String.valueOf(this.stats.variance()));
        tribbleIndexCreator.addProperty("FEATURE_COUNT", String.valueOf(this.featureCount));
        return tribbleIndexCreator.finalizeIndex(l);
    }

    private Map<IndexFactory.IndexType, TribbleIndexCreator> getIndexCreators(File file, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        IntervalIndexCreator intervalIndexCreator;
        LinearIndexCreator linearIndexCreator;
        HashMap<IndexFactory.IndexType, TribbleIndexCreator> hashMap = new HashMap<IndexFactory.IndexType, TribbleIndexCreator>();
        if (indexBalanceApproach == IndexFactory.IndexBalanceApproach.FOR_SIZE) {
            linearIndexCreator = new LinearIndexCreator(file, LinearIndexCreator.DEFAULT_BIN_WIDTH);
            hashMap.put(IndexFactory.IndexType.LINEAR, linearIndexCreator);
            intervalIndexCreator = new IntervalIndexCreator(file, IntervalIndexCreator.DEFAULT_FEATURE_COUNT);
            hashMap.put(IndexFactory.IndexType.INTERVAL_TREE, intervalIndexCreator);
        }
        if (indexBalanceApproach == IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME) {
            linearIndexCreator = new LinearIndexCreator(file, Math.max(200, LinearIndexCreator.DEFAULT_BIN_WIDTH / 4));
            hashMap.put(IndexFactory.IndexType.LINEAR, linearIndexCreator);
            intervalIndexCreator = new IntervalIndexCreator(file, Math.max(20, IntervalIndexCreator.DEFAULT_FEATURE_COUNT / 8));
            hashMap.put(IndexFactory.IndexType.INTERVAL_TREE, intervalIndexCreator);
        }
        return hashMap;
    }

    @Override
    public void addFeature(Feature feature, long l) {
        ++this.featureCount;
        this.basesSeen = this.lastFeature == null ? this.basesSeen + (long)feature.getStart() : (feature.getStart() - this.lastFeature.getStart() >= 0 ? this.basesSeen + (long)(feature.getStart() - this.lastFeature.getStart()) : this.basesSeen + (long)feature.getStart());
        this.longestFeatureLength = Math.max(this.longestFeatureLength, feature.getEnd() - feature.getStart() + 1);
        this.stats.push(this.longestFeatureLength);
        for (IndexCreator indexCreator : this.creators.values()) {
            indexCreator.addFeature(feature, l);
        }
        this.lastFeature = feature;
    }

    protected static LinkedHashMap<Double, TribbleIndexCreator> scoreIndexes(double d, Map<IndexFactory.IndexType, TribbleIndexCreator> map, int n, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        if (map.size() < 1) {
            throw new IllegalArgumentException("Please specify at least one index to evaluate");
        }
        LinkedHashMap<Double, TribbleIndexCreator> linkedHashMap = new LinkedHashMap<Double, TribbleIndexCreator>();
        for (Map.Entry<IndexFactory.IndexType, TribbleIndexCreator> entry : map.entrySet()) {
            if (entry.getValue() instanceof LinearIndexCreator) {
                double d2 = ((LinearIndexCreator)entry.getValue()).getBinSize();
                linkedHashMap.put(d2 * d * Math.ceil((double)n / d2), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof IntervalIndexCreator) {
                linkedHashMap.put(Double.valueOf(((IntervalIndexCreator)entry.getValue()).getFeaturesPerInterval()), entry.getValue());
                continue;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type, we don't have a scoring method for " + entry.getValue().getClass());
        }
        return linkedHashMap;
    }

    private TribbleIndexCreator getMinIndex(Map<Double, TribbleIndexCreator> map, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        TreeMap<Double, TribbleIndexCreator> treeMap = new TreeMap<Double, TribbleIndexCreator>();
        treeMap.putAll(map);
        TribbleIndexCreator tribbleIndexCreator = indexBalanceApproach != IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME ? (TribbleIndexCreator)treeMap.get(treeMap.lastKey()) : (TribbleIndexCreator)treeMap.get(treeMap.firstKey());
        return tribbleIndexCreator;
    }

    @Override
    public void addProperty(String string, String string2) {
        for (TribbleIndexCreator tribbleIndexCreator : this.creators.values()) {
            tribbleIndexCreator.addProperty(string, string2);
        }
    }
}

