/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.readers;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.AsynchronousLineReader;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.LongLineBufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

public class LineReaderUtil {
    public static LineReader fromBufferedStream(InputStream inputStream) {
        return LineReaderUtil.fromBufferedStream(inputStream, Defaults.USE_ASYNC_IO_FOR_TRIBBLE ? LineReaderOption.ASYNCHRONOUS : LineReaderOption.SYNCHRONOUS);
    }

    public static LineReader fromStringReader(StringReader stringReader) {
        return LineReaderUtil.fromStringReader(stringReader, Defaults.USE_ASYNC_IO_FOR_TRIBBLE ? LineReaderOption.ASYNCHRONOUS : LineReaderOption.SYNCHRONOUS);
    }

    public static LineReader fromStringReader(final StringReader stringReader, LineReaderOption lineReaderOption) {
        switch (lineReaderOption) {
            case ASYNCHRONOUS: {
                return new AsynchronousLineReader(stringReader);
            }
            case SYNCHRONOUS: {
                return new LineReader(){
                    final LongLineBufferedReader reader;
                    {
                        this.reader = new LongLineBufferedReader(stringReader);
                    }

                    @Override
                    public String readLine() {
                        try {
                            return this.reader.readLine();
                        }
                        catch (IOException iOException) {
                            throw new RuntimeIOException(iOException);
                        }
                    }

                    @Override
                    public void close() {
                        CloserUtil.close(this.reader);
                    }
                };
            }
        }
        throw new TribbleException(String.format("Unrecognized LineReaderUtil option: %s.", new Object[]{lineReaderOption}));
    }

    public static LineReader fromBufferedStream(InputStream inputStream, LineReaderOption lineReaderOption) {
        final InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        switch (lineReaderOption) {
            case ASYNCHRONOUS: {
                return new AsynchronousLineReader(inputStreamReader);
            }
            case SYNCHRONOUS: {
                return new LineReader(){
                    final LongLineBufferedReader reader;
                    {
                        this.reader = new LongLineBufferedReader(inputStreamReader);
                    }

                    @Override
                    public String readLine() {
                        try {
                            return this.reader.readLine();
                        }
                        catch (IOException iOException) {
                            throw new RuntimeIOException(iOException);
                        }
                    }

                    @Override
                    public void close() {
                        CloserUtil.close(this.reader);
                    }
                };
            }
        }
        throw new TribbleException(String.format("Unrecognized LineReaderUtil option: %s.", new Object[]{lineReaderOption}));
    }

    public static enum LineReaderOption {
        ASYNCHRONOUS,
        SYNCHRONOUS;

    }
}

