/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantJEXLContext;
import java.util.HashMap;
import java.util.Map;

public class GenotypeJEXLContext
extends VariantJEXLContext {
    private Genotype g;
    private static Map<String, AttributeGetter> attributes = new HashMap<String, AttributeGetter>();

    public GenotypeJEXLContext(VariantContext variantContext, Genotype genotype) {
        super(variantContext);
        this.g = genotype;
    }

    @Override
    public Object get(String string) {
        if (attributes.containsKey(string)) {
            return attributes.get(string).get(this.g);
        }
        if (this.g.hasAnyAttribute(string)) {
            return this.g.getAnyAttribute(string);
        }
        if (this.g.getFilters().contains(string)) {
            return "1";
        }
        return super.get(string);
    }

    static {
        attributes.put("g", genotype -> genotype);
        attributes.put("GT", Genotype::getGenotypeString);
        attributes.put("isHom", genotype -> genotype.isHom() ? "1" : "0");
        attributes.put("isHomRef", genotype -> genotype.isHomRef() ? "1" : "0");
        attributes.put("isHet", genotype -> genotype.isHet() ? "1" : "0");
        attributes.put("isHomVar", genotype -> genotype.isHomVar() ? "1" : "0");
        attributes.put("isCalled", genotype -> genotype.isCalled() ? "1" : "0");
        attributes.put("isNoCall", genotype -> genotype.isNoCall() ? "1" : "0");
        attributes.put("isMixed", genotype -> genotype.isMixed() ? "1" : "0");
        attributes.put("isAvailable", genotype -> genotype.isAvailable() ? "1" : "0");
        attributes.put("isPassFT", genotype -> genotype.isFiltered() ? "0" : "1");
        attributes.put("FT", genotype -> genotype.isFiltered() ? genotype.getFilters() : "PASS");
        attributes.put("GQ", Genotype::getGQ);
    }

    private static interface AttributeGetter {
        public Object get(Genotype var1);
    }
}

