/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeJEXLContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.VariantJEXLContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;

class JEXLMap
implements Map<VariantContextUtils.JexlVCMatchExp, Boolean> {
    private final VariantContext vc;
    private final Genotype g;
    private JexlContext jContext = null;
    private Map<VariantContextUtils.JexlVCMatchExp, Boolean> jexl;

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> collection, VariantContext variantContext, Genotype genotype) {
        this.vc = variantContext;
        this.g = genotype;
        this.initialize(collection);
    }

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> collection, VariantContext variantContext) {
        this(collection, variantContext, null);
    }

    private void initialize(Collection<VariantContextUtils.JexlVCMatchExp> collection) {
        this.jexl = new HashMap<VariantContextUtils.JexlVCMatchExp, Boolean>();
        for (VariantContextUtils.JexlVCMatchExp jexlVCMatchExp : collection) {
            this.jexl.put(jexlVCMatchExp, null);
        }
    }

    private void createContext() {
        this.jContext = this.vc == null ? new MapContext(Collections.emptyMap()) : (this.g == null ? new VariantJEXLContext(this.vc) : new GenotypeJEXLContext(this.vc, this.g));
    }

    @Override
    public int size() {
        return this.jexl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jexl.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.jexl.containsKey(object);
    }

    @Override
    public Boolean get(Object object) {
        if (this.jexl.containsKey(object) && this.jexl.get(object) != null) {
            return this.jexl.get(object);
        }
        VariantContextUtils.JexlVCMatchExp jexlVCMatchExp = (VariantContextUtils.JexlVCMatchExp)object;
        this.evaluateExpression(jexlVCMatchExp);
        return this.jexl.get(jexlVCMatchExp);
    }

    @Override
    public Set<VariantContextUtils.JexlVCMatchExp> keySet() {
        return this.jexl.keySet();
    }

    @Override
    public Collection<Boolean> values() {
        for (VariantContextUtils.JexlVCMatchExp jexlVCMatchExp : this.jexl.keySet()) {
            if (this.jexl.get(jexlVCMatchExp) != null) continue;
            this.evaluateExpression(jexlVCMatchExp);
        }
        return this.jexl.values();
    }

    private void evaluateExpression(VariantContextUtils.JexlVCMatchExp jexlVCMatchExp) {
        if (this.jContext == null) {
            this.createContext();
        }
        try {
            Boolean bl = (Boolean)jexlVCMatchExp.exp.evaluate(this.jContext);
            this.jexl.put(jexlVCMatchExp, bl == null ? false : bl);
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("undefined variable")) {
                this.jexl.put(jexlVCMatchExp, false);
            }
            throw new IllegalArgumentException(String.format("Invalid JEXL expression detected for %s with message %s", jexlVCMatchExp.name, exception.getMessage() == null ? "no message" : exception.getMessage()));
        }
    }

    private static void addAttributesToMap(Map<String, Object> map, Map<String, ?> map2) {
        for (Map.Entry<String, ?> entry : map2.entrySet()) {
            map.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    @Override
    public Boolean put(VariantContextUtils.JexlVCMatchExp jexlVCMatchExp, Boolean bl) {
        return this.jexl.put(jexlVCMatchExp, bl);
    }

    @Override
    public void putAll(Map<? extends VariantContextUtils.JexlVCMatchExp, ? extends Boolean> map) {
        this.jexl.putAll(map);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException("containsValue() not supported on a JEXLMap");
    }

    @Override
    public Boolean remove(Object object) {
        throw new UnsupportedOperationException("remove() not supported on a JEXLMap");
    }

    @Override
    public Set<Map.Entry<VariantContextUtils.JexlVCMatchExp, Boolean>> entrySet() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }
}

