/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;

class VariantJEXLContext
implements JexlContext {
    private VariantContext vc;
    private static Map<String, AttributeGetter> attributes = new HashMap<String, AttributeGetter>();

    public VariantJEXLContext(VariantContext variantContext) {
        this.vc = variantContext;
    }

    public Object get(String string) {
        Object object = null;
        if (attributes.containsKey(string)) {
            object = attributes.get(string).get(this.vc);
        } else if (this.vc.hasAttribute(string)) {
            object = this.vc.getAttribute(string);
        } else if (this.vc.getFilters().contains(string)) {
            object = "1";
        }
        return object;
    }

    public boolean has(String string) {
        return this.get(string) != null;
    }

    public void set(String string, Object object) {
        throw new UnsupportedOperationException("remove() not supported on a VariantJEXLContext");
    }

    static {
        attributes.put("vc", variantContext -> variantContext);
        attributes.put("CHROM", VariantContext::getChr);
        attributes.put("POS", VariantContext::getStart);
        attributes.put("TYPE", variantContext -> variantContext.getType().toString());
        attributes.put("QUAL", variantContext -> -10.0 * variantContext.getLog10PError());
        attributes.put("ALLELES", VariantContext::getAlleles);
        attributes.put("N_ALLELES", VariantContext::getNAlleles);
        attributes.put("FILTER", variantContext -> variantContext.isFiltered() ? "1" : "0");
        attributes.put("homRefCount", VariantContext::getHomRefCount);
        attributes.put("hetCount", VariantContext::getHetCount);
        attributes.put("homVarCount", VariantContext::getHomVarCount);
    }

    private static interface AttributeGetter {
        public Object get(VariantContext var1);
    }
}

