/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.variantcontext.writer.BCF2Encoder;
import htsjdk.variant.variantcontext.writer.BCF2FieldEncoder;
import htsjdk.variant.variantcontext.writer.BCF2FieldWriter;
import htsjdk.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashMap;
import java.util.Map;

public class BCF2FieldWriterManager {
    final Map<String, BCF2FieldWriter.SiteWriter> siteWriters = new HashMap<String, BCF2FieldWriter.SiteWriter>();
    final Map<String, BCF2FieldWriter.GenotypesWriter> genotypesWriters = new HashMap<String, BCF2FieldWriter.GenotypesWriter>();
    final IntGenotypeFieldAccessors intGenotypeFieldAccessors = new IntGenotypeFieldAccessors();

    public void setup(VCFHeader vCFHeader, BCF2Encoder bCF2Encoder, Map<String, Integer> map) {
        BCF2FieldWriter bCF2FieldWriter;
        String string;
        for (VCFInfoHeaderLine vCFCompoundHeaderLine : vCFHeader.getInfoHeaderLines()) {
            string = vCFCompoundHeaderLine.getID();
            bCF2FieldWriter = this.createInfoWriter(vCFHeader, vCFCompoundHeaderLine, bCF2Encoder, map);
            this.add(this.siteWriters, string, bCF2FieldWriter);
        }
        for (VCFFormatHeaderLine vCFFormatHeaderLine : vCFHeader.getFormatHeaderLines()) {
            string = vCFFormatHeaderLine.getID();
            bCF2FieldWriter = this.createGenotypesWriter(vCFHeader, vCFFormatHeaderLine, bCF2Encoder, map);
            this.add(this.genotypesWriters, string, bCF2FieldWriter);
        }
    }

    private final <T> void add(Map<String, T> map, String string, T t) {
        if (map.containsKey(string)) {
            throw new IllegalStateException("BUG: field " + string + " already seen in VCFHeader while building BCF2 field encoders");
        }
        map.put(string, t);
    }

    private BCF2FieldWriter.SiteWriter createInfoWriter(VCFHeader vCFHeader, VCFInfoHeaderLine vCFInfoHeaderLine, BCF2Encoder bCF2Encoder, Map<String, Integer> map) {
        return new BCF2FieldWriter.GenericSiteWriter(vCFHeader, this.createFieldEncoder(vCFInfoHeaderLine, bCF2Encoder, map, false));
    }

    private BCF2FieldEncoder createFieldEncoder(VCFCompoundHeaderLine vCFCompoundHeaderLine, BCF2Encoder bCF2Encoder, Map<String, Integer> map, boolean bl) {
        if (bl && this.intGenotypeFieldAccessors.getAccessor(vCFCompoundHeaderLine.getID()) != null) {
            return new BCF2FieldEncoder.IntArray(vCFCompoundHeaderLine, map);
        }
        if (bl && vCFCompoundHeaderLine.getID().equals("GT")) {
            return new BCF2FieldEncoder.GenericInts(vCFCompoundHeaderLine, map);
        }
        switch (vCFCompoundHeaderLine.getType()) {
            case Character: 
            case String: {
                return new BCF2FieldEncoder.StringOrCharacter(vCFCompoundHeaderLine, map);
            }
            case Flag: {
                return new BCF2FieldEncoder.Flag(vCFCompoundHeaderLine, map);
            }
            case Float: {
                return new BCF2FieldEncoder.Float(vCFCompoundHeaderLine, map);
            }
            case Integer: {
                if (vCFCompoundHeaderLine.isFixedCount() && vCFCompoundHeaderLine.getCount() == 1) {
                    return new BCF2FieldEncoder.AtomicInt(vCFCompoundHeaderLine, map);
                }
                return new BCF2FieldEncoder.GenericInts(vCFCompoundHeaderLine, map);
            }
        }
        throw new IllegalArgumentException("Unexpected type for field " + vCFCompoundHeaderLine.getID());
    }

    private BCF2FieldWriter.GenotypesWriter createGenotypesWriter(VCFHeader vCFHeader, VCFFormatHeaderLine vCFFormatHeaderLine, BCF2Encoder bCF2Encoder, Map<String, Integer> map) {
        String string = vCFFormatHeaderLine.getID();
        BCF2FieldEncoder bCF2FieldEncoder = this.createFieldEncoder(vCFFormatHeaderLine, bCF2Encoder, map, true);
        if (string.equals("GT")) {
            return new BCF2FieldWriter.GTWriter(vCFHeader, bCF2FieldEncoder);
        }
        if (vCFFormatHeaderLine.getID().equals("FT")) {
            return new BCF2FieldWriter.FTGenotypesWriter(vCFHeader, bCF2FieldEncoder);
        }
        if (this.intGenotypeFieldAccessors.getAccessor(string) != null) {
            return new BCF2FieldWriter.IGFGenotypesWriter(vCFHeader, bCF2FieldEncoder, this.intGenotypeFieldAccessors.getAccessor(string));
        }
        if (vCFFormatHeaderLine.getType() == VCFHeaderLineType.Integer) {
            return new BCF2FieldWriter.IntegerTypeGenotypesWriter(vCFHeader, bCF2FieldEncoder);
        }
        return new BCF2FieldWriter.StaticallyTypeGenotypesWriter(vCFHeader, bCF2FieldEncoder);
    }

    public BCF2FieldWriter.SiteWriter getSiteFieldWriter(String string) {
        return this.getWriter(string, this.siteWriters);
    }

    public BCF2FieldWriter.GenotypesWriter getGenotypeFieldWriter(String string) {
        return this.getWriter(string, this.genotypesWriters);
    }

    public <T> T getWriter(String string, Map<String, T> map) {
        return map.get(string);
    }
}

