/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.writer.AsyncVariantContextWriter;
import htsjdk.variant.variantcontext.writer.BCF2Writer;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.SortingVariantContextWriter;
import htsjdk.variant.variantcontext.writer.VCFWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;

@Deprecated
public class VariantContextWriterFactory {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);

    private VariantContextWriterFactory() {
    }

    public static VariantContextWriter create(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return VariantContextWriterFactory.create(file, VariantContextWriterFactory.openOutputStream(file), sAMSequenceDictionary, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(File file, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.create(file, VariantContextWriterFactory.openOutputStream(file), sAMSequenceDictionary, enumSet);
    }

    public static VariantContextWriter create(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary) {
        return VariantContextWriterFactory.create(file, outputStream, sAMSequenceDictionary, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.create(null, outputStream, sAMSequenceDictionary, enumSet);
    }

    public static VariantContextWriter createBcf2(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new BCF2Writer(file, outputStream, sAMSequenceDictionary, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES)), enumSet);
    }

    public static VariantContextWriter createBcf2(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, IndexCreator indexCreator, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new BCF2Writer(file, outputStream, sAMSequenceDictionary, indexCreator, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES)), enumSet);
    }

    public static VariantContextWriter createVcf(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(file, outputStream, sAMSequenceDictionary, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), enumSet.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), enumSet.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), enumSet);
    }

    public static VariantContextWriter createVcf(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, IndexCreator indexCreator, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(file, outputStream, sAMSequenceDictionary, indexCreator, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), enumSet.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), enumSet.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), enumSet);
    }

    public static VariantContextWriter createBlockCompressedVcf(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        TabixIndexCreator tabixIndexCreator = enumSet.contains((Object)Options.INDEX_ON_THE_FLY) ? new TabixIndexCreator(sAMSequenceDictionary, TabixFormat.VCF) : null;
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(file, BlockCompressedOutputStream.maybeBgzfWrapOutputStream(file, outputStream), sAMSequenceDictionary, tabixIndexCreator, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), enumSet.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), enumSet.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), enumSet);
    }

    public static VariantContextWriter createBlockCompressedVcf(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, IndexCreator indexCreator, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(file, BlockCompressedOutputStream.maybeBgzfWrapOutputStream(file, outputStream), sAMSequenceDictionary, indexCreator, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), enumSet.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), enumSet.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), enumSet);
    }

    public static VariantContextWriter create(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        if (VariantContextWriterFactory.isBCFOutput(file, enumSet)) {
            return VariantContextWriterFactory.createBcf2(file, outputStream, sAMSequenceDictionary, enumSet);
        }
        if (VariantContextWriterFactory.isCompressedVcf(file)) {
            return VariantContextWriterFactory.createBlockCompressedVcf(file, outputStream, sAMSequenceDictionary, enumSet);
        }
        return VariantContextWriterFactory.createVcf(file, outputStream, sAMSequenceDictionary, enumSet);
    }

    public static VariantContextWriter create(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, IndexCreator indexCreator, EnumSet<Options> enumSet) {
        if (VariantContextWriterFactory.isBCFOutput(file, enumSet)) {
            return VariantContextWriterFactory.createBcf2(file, outputStream, sAMSequenceDictionary, indexCreator, enumSet);
        }
        if (VariantContextWriterFactory.isCompressedVcf(file)) {
            return VariantContextWriterFactory.createBlockCompressedVcf(file, outputStream, sAMSequenceDictionary, indexCreator, enumSet);
        }
        return VariantContextWriterFactory.createVcf(file, outputStream, sAMSequenceDictionary, indexCreator, enumSet);
    }

    private static VariantContextWriter maybeWrapWithAsyncWriter(VariantContextWriter variantContextWriter, EnumSet<Options> enumSet) {
        if (enumSet.contains((Object)Options.USE_ASYNC_IO)) {
            return new AsyncVariantContextWriter(variantContextWriter, 2000);
        }
        return variantContextWriter;
    }

    public static boolean isBCFOutput(File file) {
        return VariantContextWriterFactory.isBCFOutput(file, EnumSet.noneOf(Options.class));
    }

    public static boolean isBCFOutput(File file, EnumSet<Options> enumSet) {
        return enumSet.contains((Object)Options.FORCE_BCF) || file != null && file.getName().contains(".bcf");
    }

    public static boolean isCompressedVcf(File file) {
        if (file == null) {
            return false;
        }
        return AbstractFeatureReader.hasBlockCompressedExtension(file);
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter variantContextWriter, int n) {
        return VariantContextWriterFactory.sortOnTheFly(variantContextWriter, n, false);
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter variantContextWriter, int n, boolean bl) {
        return new SortingVariantContextWriter(variantContextWriter, n, bl);
    }

    protected static OutputStream openOutputStream(File file) {
        try {
            return IOUtil.maybeBufferOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeIOException(file + ": Unable to create VCF writer", fileNotFoundException);
        }
    }

    static {
        if (Defaults.USE_ASYNC_IO_FOR_TRIBBLE) {
            DEFAULT_OPTIONS.add(Options.USE_ASYNC_IO);
        }
    }
}

