/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class VCFFileReader
implements Closeable,
Iterable<VariantContext> {
    private final FeatureReader<VariantContext> reader;

    public static boolean isBCF(File file) {
        return file.getAbsolutePath().endsWith(".bcf");
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        SAMSequenceDictionary sAMSequenceDictionary = new VCFFileReader(file, false).getFileHeader().getSequenceDictionary();
        CloserUtil.close(file);
        return sAMSequenceDictionary;
    }

    public VCFFileReader(File file) {
        this(file, true);
    }

    public VCFFileReader(File file, File file2) {
        this(file, file2, true);
    }

    public VCFFileReader(File file, boolean bl) {
        FeatureCodec<VariantContext, PositionalBufferedStream> featureCodec = VCFFileReader.isBCF(file) ? new BCF2Codec() : new VCFCodec();
        this.reader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), featureCodec, bl);
    }

    public VCFFileReader(File file, File file2, boolean bl) {
        FeatureCodec<VariantContext, PositionalBufferedStream> featureCodec = VCFFileReader.isBCF(file) ? new BCF2Codec() : new VCFCodec();
        this.reader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), file2.getAbsolutePath(), featureCodec, bl);
    }

    public static IntervalList fromVcf(File file) {
        return VCFFileReader.fromVcf(file, false);
    }

    public static IntervalList fromVcf(File file, boolean bl) {
        VCFFileReader vCFFileReader = new VCFFileReader(file, false);
        IntervalList intervalList = VCFFileReader.fromVcf(vCFFileReader, bl);
        vCFFileReader.close();
        return intervalList;
    }

    public static IntervalList fromVcf(VCFFileReader vCFFileReader) {
        return VCFFileReader.fromVcf(vCFFileReader, false);
    }

    public static IntervalList fromVcf(VCFFileReader vCFFileReader, boolean bl) {
        SAMSequenceDictionary sAMSequenceDictionary = vCFFileReader.getFileHeader().getSequenceDictionary();
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
        IntervalList intervalList = new IntervalList(sAMFileHeader);
        int n = 0;
        for (VariantContext variantContext : vCFFileReader) {
            if (!bl && variantContext.isFiltered()) continue;
            String string = variantContext.getID();
            Integer n2 = variantContext.getCommonInfo().getAttributeAsInt("END", variantContext.getEnd());
            if (".".equals(string) || string == null) {
                string = "interval-" + ++n;
            }
            intervalList.add(new Interval(variantContext.getChr(), variantContext.getStart(), n2, false, string));
        }
        return intervalList;
    }

    public VCFHeader getFileHeader() {
        return (VCFHeader)this.reader.getHeader();
    }

    @Override
    public CloseableIterator<VariantContext> iterator() {
        try {
            return this.reader.iterator();
        }
        catch (IOException iOException) {
            throw new TribbleException("Could not create an iterator from a feature reader.", iOException);
        }
    }

    public CloseableIterator<VariantContext> query(String string, int n, int n2) {
        try {
            return this.reader.query(string, n, n2);
        }
        catch (IOException iOException) {
            throw new TribbleException("Could not create an iterator from a feature reader.", iOException);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new TribbleException("Could not close a variant context feature reader.", iOException);
        }
    }
}

