/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMBAIIndexer;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.build.Sam2CramRecordFactory;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScorePreservation;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CRAMContainerStreamWriter {
    private static final Version cramVersion = CramVersions.DEFAULT_CRAM_VERSION;
    static int DEFAULT_RECORDS_PER_SLICE = 10000;
    static int MIN_SINGLE_REF_RECORDS = 1000;
    protected final int recordsPerSlice = DEFAULT_RECORDS_PER_SLICE;
    private static final int DEFAULT_SLICES_PER_CONTAINER = 1;
    protected final int containerSize = this.recordsPerSlice * 1;
    private static final int REF_SEQ_INDEX_NOT_INITIALIZED = -3;
    private final SAMFileHeader samFileHeader;
    private final String cramID;
    private final OutputStream outputStream;
    private ReferenceSource source;
    private final List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ContainerFactory containerFactory;
    private int refSeqIndex = -3;
    private static final Log log = Log.getInstance(CRAMContainerStreamWriter.class);
    private boolean preserveReadNames = true;
    private QualityScorePreservation preservation = null;
    private boolean captureAllTags = true;
    private Set<String> captureTags = new TreeSet<String>();
    private Set<String> ignoreTags = new TreeSet<String>();
    private CRAMBAIIndexer indexer;
    private long offset;

    public CRAMContainerStreamWriter(OutputStream outputStream, OutputStream outputStream2, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        this.outputStream = outputStream;
        this.samFileHeader = sAMFileHeader;
        this.cramID = string;
        this.source = referenceSource;
        this.containerFactory = new ContainerFactory(sAMFileHeader, this.recordsPerSlice);
        if (outputStream2 != null) {
            this.indexer = new CRAMBAIIndexer(outputStream2, sAMFileHeader);
        }
    }

    public void writeAlignment(SAMRecord sAMRecord) {
        if (this.shouldFlushContainer(sAMRecord)) {
            try {
                this.flushContainer();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        this.updateReferenceContext(sAMRecord.getReferenceIndex());
        this.samRecords.add(sAMRecord);
    }

    public void writeHeader(SAMFileHeader sAMFileHeader) {
        this.offset = CramIO.writeHeader(cramVersion, this.outputStream, sAMFileHeader, this.cramID);
    }

    public void finish(boolean bl) {
        try {
            if (!this.samRecords.isEmpty()) {
                this.flushContainer();
            }
            if (bl) {
                CramIO.issueEOF(cramVersion, this.outputStream);
            }
            this.outputStream.flush();
            if (this.indexer != null) {
                this.indexer.finish();
            }
            this.outputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean bl) {
        this.preserveReadNames = bl;
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        if (this.preservation == null) {
            this.preservation = new QualityScorePreservation("*8");
        }
        return this.preservation.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.captureAllTags;
    }

    public void setCaptureAllTags(boolean bl) {
        this.captureAllTags = bl;
    }

    public Set<String> getCaptureTags() {
        return this.captureTags;
    }

    public void setCaptureTags(Set<String> set) {
        this.captureTags = set;
    }

    public Set<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public void setIgnoreTags(Set<String> set) {
        this.ignoreTags = set;
    }

    protected boolean shouldFlushContainer(SAMRecord sAMRecord) {
        boolean bl;
        if (this.samRecords.isEmpty()) {
            this.refSeqIndex = sAMRecord.getReferenceIndex();
            return false;
        }
        if (this.samRecords.size() >= this.containerSize) {
            return true;
        }
        if (this.samFileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            return false;
        }
        if (this.refSeqIndex != -1 && sAMRecord.getReferenceIndex() == -1) {
            return true;
        }
        if (this.refSeqIndex == -2) {
            return false;
        }
        boolean bl2 = bl = this.refSeqIndex == sAMRecord.getReferenceIndex();
        if (bl) {
            return false;
        }
        if (this.samRecords.size() > MIN_SINGLE_REF_RECORDS) {
            return true;
        }
        this.refSeqIndex = -2;
        return false;
    }

    private static void updateTracks(List<SAMRecord> list, ReferenceTracks referenceTracks) {
        for (SAMRecord sAMRecord : list) {
            if (sAMRecord.getAlignmentStart() == 0) continue;
            int n = sAMRecord.getAlignmentStart();
            int n2 = 0;
            for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                int n3;
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    for (n3 = 0; n3 < cigarElement.getLength(); ++n3) {
                        referenceTracks.addCoverage(n + n3, 1);
                    }
                }
                switch (cigarElement.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        for (n3 = n2; n3 < cigarElement.getLength(); ++n3) {
                            byte by;
                            byte by2 = sAMRecord.getReadBases()[n2 + n3];
                            if (by2 == (by = referenceTracks.baseAt(n + n3))) continue;
                            referenceTracks.addMismatches(n + n3, 1);
                        }
                        break;
                    }
                }
                n2 += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                n += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void flushContainer() throws IllegalArgumentException, IllegalAccessException, IOException {
        byte[] byArray;
        String string = null;
        switch (this.refSeqIndex) {
            case -2: {
                if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
                    throw new SAMException("Cannot apply reference-based lossy compression on non-coordinate sorted reads.");
                }
                byArray = new byte[]{};
                break;
            }
            case -1: {
                byArray = new byte[]{};
                break;
            }
            default: {
                SAMSequenceRecord sAMSequenceRecord = this.samFileHeader.getSequence(this.refSeqIndex);
                byArray = this.source.getReferenceBases(sAMSequenceRecord, true);
                string = sAMSequenceRecord.getSequenceName();
            }
        }
        int n = 0;
        int n2 = 0;
        for (SAMRecord cloneable2 : this.samRecords) {
            if (cloneable2.getAlignmentStart() == 0) continue;
            if (n == 0) {
                n = cloneable2.getAlignmentStart();
            }
            n = Math.min(cloneable2.getAlignmentStart(), n);
            n2 = Math.max(cloneable2.getAlignmentEnd(), n2);
        }
        Object object4 = null;
        if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
            object4 = new ReferenceTracks(this.refSeqIndex, string, byArray);
            ((ReferenceTracks)object4).ensureRange(n, n2 - n + 1);
            CRAMContainerStreamWriter.updateTracks(this.samRecords, (ReferenceTracks)object4);
        }
        ArrayList<CramCompressionRecord> arrayList = new ArrayList<CramCompressionRecord>(this.samRecords.size());
        Sam2CramRecordFactory sam2CramRecordFactory = new Sam2CramRecordFactory(byArray, this.samFileHeader, cramVersion);
        sam2CramRecordFactory.preserveReadNames = this.preserveReadNames;
        sam2CramRecordFactory.captureAllTags = this.captureAllTags;
        sam2CramRecordFactory.captureTags.addAll(this.captureTags);
        sam2CramRecordFactory.ignoreTags.addAll(this.ignoreTags);
        this.containerFactory.setPreserveReadNames(this.preserveReadNames);
        int n3 = 0;
        int n4 = n;
        for (SAMRecord sAMRecord : this.samRecords) {
            if (sAMRecord.getReferenceIndex() != -1 && this.refSeqIndex != sAMRecord.getReferenceIndex()) {
                sam2CramRecordFactory.setRefBases(this.source.getReferenceBases(this.samFileHeader.getSequence(sAMRecord.getReferenceIndex()), true));
            }
            Iterator<Object> iterator = sam2CramRecordFactory.createCramRecord(sAMRecord);
            ((CramCompressionRecord)((Object)iterator)).index = ++n3;
            ((CramCompressionRecord)((Object)iterator)).alignmentDelta = sAMRecord.getAlignmentStart() - n4;
            ((CramCompressionRecord)((Object)iterator)).alignmentStart = sAMRecord.getAlignmentStart();
            n4 = sAMRecord.getAlignmentStart();
            arrayList.add((CramCompressionRecord)((Object)iterator));
            if (this.preservation != null) {
                this.preservation.addQualityScores(sAMRecord, (CramCompressionRecord)((Object)iterator), (ReferenceTracks)object4);
                continue;
            }
            if (((CramCompressionRecord)((Object)iterator)).qualityScores == SAMRecord.NULL_QUALS) continue;
            ((CramCompressionRecord)((Object)iterator)).setForcePreserveQualityScores(true);
        }
        if (sam2CramRecordFactory.getBaseCount() < 3L * sam2CramRecordFactory.getFeatureCount()) {
            log.warn("Abnormally high number of mismatches, possibly wrong reference.");
        }
        if (this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate) {
            TreeMap bl = new TreeMap();
            TreeMap treeMap = new TreeMap();
            for (Object object : arrayList) {
                if (!((CramCompressionRecord)object).isMultiFragment()) {
                    ((CramCompressionRecord)object).setDetached(true);
                    ((CramCompressionRecord)object).setHasMateDownStream(false);
                    ((CramCompressionRecord)object).recordsToNextFragment = -1;
                    ((CramCompressionRecord)object).next = null;
                    ((CramCompressionRecord)object).previous = null;
                    continue;
                }
                String string2 = ((CramCompressionRecord)object).readName;
                Object object2 = ((CramCompressionRecord)object).isSecondaryAlignment() ? treeMap : bl;
                CramCompressionRecord cramCompressionRecord = (CramCompressionRecord)object2.get(string2);
                if (cramCompressionRecord == null) {
                    object2.put(string2, object);
                    continue;
                }
                CramCompressionRecord cramCompressionRecord2 = cramCompressionRecord;
                while (cramCompressionRecord2.next != null) {
                    cramCompressionRecord2 = cramCompressionRecord2.next;
                }
                cramCompressionRecord2.recordsToNextFragment = ((CramCompressionRecord)object).index - cramCompressionRecord2.index - 1;
                cramCompressionRecord2.next = object;
                ((CramCompressionRecord)object).previous = cramCompressionRecord2;
                ((CramCompressionRecord)object).previous.setHasMateDownStream(true);
                ((CramCompressionRecord)object).setHasMateDownStream(false);
                ((CramCompressionRecord)object).setDetached(false);
                ((CramCompressionRecord)object).previous.setDetached(false);
            }
            for (Object object : arrayList) {
                void var14_31;
                if (((CramCompressionRecord)object).next == null || ((CramCompressionRecord)object).previous != null) continue;
                CramCompressionRecord cramCompressionRecord = object;
                while (var14_31.next != null) {
                    CramCompressionRecord cramCompressionRecord3 = var14_31.next;
                }
                if (((CramCompressionRecord)object).isFirstSegment() && var14_31.isLastSegment()) {
                    int n5 = CramNormalizer.computeInsertSize((CramCompressionRecord)object, (CramCompressionRecord)var14_31);
                    if (((CramCompressionRecord)object).templateSize == n5) {
                        void var14_34;
                        CramCompressionRecord cramCompressionRecord4 = ((CramCompressionRecord)object).next;
                        while (var14_34.next != null && var14_34.templateSize == -n5) {
                            CramCompressionRecord cramCompressionRecord5 = var14_34.next;
                        }
                        if (var14_34.templateSize == -n5) continue;
                        CRAMContainerStreamWriter.detach((CramCompressionRecord)object);
                        continue;
                    }
                    CRAMContainerStreamWriter.detach((CramCompressionRecord)object);
                    continue;
                }
                CRAMContainerStreamWriter.detach((CramCompressionRecord)object);
            }
            for (Object object : bl.values()) {
                if (((CramCompressionRecord)object).next != null) continue;
                ((CramCompressionRecord)object).setDetached(true);
                ((CramCompressionRecord)object).setHasMateDownStream(false);
                ((CramCompressionRecord)object).recordsToNextFragment = -1;
                ((CramCompressionRecord)object).next = null;
                ((CramCompressionRecord)object).previous = null;
            }
            for (Object object : treeMap.values()) {
                if (((CramCompressionRecord)object).next != null) continue;
                ((CramCompressionRecord)object).setDetached(true);
                ((CramCompressionRecord)object).setHasMateDownStream(false);
                ((CramCompressionRecord)object).recordsToNextFragment = -1;
                ((CramCompressionRecord)object).next = null;
                ((CramCompressionRecord)object).previous = null;
            }
        } else {
            for (CramCompressionRecord cramCompressionRecord : arrayList) {
                cramCompressionRecord.setDetached(true);
            }
        }
        boolean container = false;
        if (!$assertionsDisabled) {
            container = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (container) {
            Cram2SamRecordFactory cram2SamRecordFactory = new Cram2SamRecordFactory(this.samFileHeader);
            for (int i = 0; i < this.samRecords.size(); ++i) {
                Object object;
                object = cram2SamRecordFactory.create((CramCompressionRecord)arrayList.get(i));
                assert (((SAMRecord)object).getAlignmentStart() == this.samRecords.get(i).getAlignmentStart());
                assert (((SAMRecord)object).getReferenceName().equals(this.samRecords.get(i).getReferenceName()));
                assert (((SAMRecord)object).getReadString().equals(this.samRecords.get(i).getReadString()));
                assert (((SAMRecord)object).getBaseQualityString().equals(this.samRecords.get(i).getBaseQualityString()));
            }
        }
        Container container2 = this.containerFactory.buildContainer(arrayList);
        for (Slice slice : container2.slices) {
            slice.setRefMD5(byArray);
        }
        container2.offset = this.offset;
        this.offset += (long)ContainerIO.writeContainer(cramVersion, container2, this.outputStream);
        if (this.indexer != null) {
            this.indexer.processContainer(container2, ValidationStringency.SILENT);
        }
        this.samRecords.clear();
        this.refSeqIndex = -3;
    }

    private static void detach(CramCompressionRecord cramCompressionRecord) {
        do {
            cramCompressionRecord.setDetached(true);
            cramCompressionRecord.setHasMateDownStream(false);
            cramCompressionRecord.recordsToNextFragment = -1;
        } while ((cramCompressionRecord = cramCompressionRecord.next) != null);
    }

    private void updateReferenceContext(int n) {
        if (this.refSeqIndex == -2) {
            return;
        }
        if (this.refSeqIndex == -3) {
            this.refSeqIndex = n;
        } else if (this.refSeqIndex != n) {
            this.refSeqIndex = -2;
        }
    }
}

