/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.util.Log;
import java.io.File;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class Defaults {
    private static Log log = Log.getInstance(Defaults.class);
    public static final boolean CREATE_INDEX = Defaults.getBooleanProperty("create_index", false);
    public static final boolean CREATE_MD5 = Defaults.getBooleanProperty("create_md5", false);
    public static final boolean USE_ASYNC_IO;
    public static final boolean USE_ASYNC_IO_FOR_SAMTOOLS;
    public static final boolean USE_ASYNC_IO_FOR_TRIBBLE;
    public static final int COMPRESSION_LEVEL;
    public static final int BUFFER_SIZE;
    public static final int NON_ZERO_BUFFER_SIZE;
    public static final boolean TRY_USE_INTEL_DEFLATER;
    public static final String INTEL_DEFLATER_SHARED_LIBRARY_PATH;
    public static final File REFERENCE_FASTA;
    public static final String CUSTOM_READER_FACTORY;
    public static final boolean USE_CRAM_REF_DOWNLOAD;
    public static final String EBI_REFERENCE_SEVICE_URL_MASK;

    public static SortedMap<String, Object> allDefaults() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("CREATE_INDEX", CREATE_INDEX);
        treeMap.put("CREATE_MD5", CREATE_MD5);
        treeMap.put("USE_ASYNC_IO", USE_ASYNC_IO);
        treeMap.put("USE_ASYNC_IO_FOR_SAMTOOLS", USE_ASYNC_IO_FOR_SAMTOOLS);
        treeMap.put("USE_ASYNC_IO_FOR_TRIBBLE", USE_ASYNC_IO_FOR_TRIBBLE);
        treeMap.put("COMPRESSION_LEVEL", COMPRESSION_LEVEL);
        treeMap.put("BUFFER_SIZE", BUFFER_SIZE);
        treeMap.put("TRY_USE_INTEL_DEFLATER", TRY_USE_INTEL_DEFLATER);
        treeMap.put("INTEL_DEFLATER_SHARED_LIBRARY_PATH", INTEL_DEFLATER_SHARED_LIBRARY_PATH);
        treeMap.put("NON_ZERO_BUFFER_SIZE", NON_ZERO_BUFFER_SIZE);
        treeMap.put("REFERENCE_FASTA", REFERENCE_FASTA);
        treeMap.put("USE_CRAM_REF_DOWNLOAD", USE_CRAM_REF_DOWNLOAD);
        treeMap.put("EBI_REFERENCE_SEVICE_URL_MASK", EBI_REFERENCE_SEVICE_URL_MASK);
        treeMap.put("CUSTOM_READER_FACTORY", CUSTOM_READER_FACTORY);
        return Collections.unmodifiableSortedMap(treeMap);
    }

    private static String getStringProperty(String string, String string2) {
        try {
            return System.getProperty("samjdk." + string, string2);
        }
        catch (AccessControlException accessControlException) {
            log.warn(accessControlException, "java Security Manager forbids 'System.getProperty(\"" + string + "\")' , returning default value: " + string2);
            return string2;
        }
    }

    private static boolean hasProperty(String string) {
        try {
            return null != System.getProperty("samjdk." + string);
        }
        catch (AccessControlException accessControlException) {
            log.warn(accessControlException, "java Security Manager forbids 'System.getProperty(\"" + string + "\")' , returning false");
            return false;
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = Defaults.getStringProperty(string, Boolean.toString(bl));
        return Boolean.parseBoolean(string2);
    }

    private static int getIntProperty(String string, int n) {
        String string2 = Defaults.getStringProperty(string, Integer.toString(n));
        return Integer.parseInt(string2);
    }

    private static File getFileProperty(String string, String string2) {
        String string3 = Defaults.getStringProperty(string, string2);
        return null == string3 ? null : new File(string3);
    }

    static {
        if (Defaults.hasProperty("use_async_io")) {
            USE_ASYNC_IO_FOR_SAMTOOLS = USE_ASYNC_IO = Defaults.getBooleanProperty("use_async_io", false);
            USE_ASYNC_IO_FOR_TRIBBLE = USE_ASYNC_IO;
        } else {
            USE_ASYNC_IO = false;
            USE_ASYNC_IO_FOR_SAMTOOLS = Defaults.getBooleanProperty("use_async_io_samtools", false);
            USE_ASYNC_IO_FOR_TRIBBLE = Defaults.getBooleanProperty("use_async_io_tribble", false);
        }
        COMPRESSION_LEVEL = Defaults.getIntProperty("compression_level", 5);
        BUFFER_SIZE = Defaults.getIntProperty("buffer_size", 131072);
        TRY_USE_INTEL_DEFLATER = Defaults.getBooleanProperty("try_use_intel_deflater", true);
        INTEL_DEFLATER_SHARED_LIBRARY_PATH = Defaults.getStringProperty("intel_deflater_so_path", null);
        NON_ZERO_BUFFER_SIZE = BUFFER_SIZE == 0 ? 131072 : BUFFER_SIZE;
        REFERENCE_FASTA = Defaults.getFileProperty("reference_fasta", null);
        USE_CRAM_REF_DOWNLOAD = Defaults.getBooleanProperty("use_cram_ref_download", false);
        EBI_REFERENCE_SEVICE_URL_MASK = "http://www.ebi.ac.uk/ena/cram/md5/%s";
        CUSTOM_READER_FACTORY = Defaults.getStringProperty("custom_reader", "");
    }
}

