/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

class HighAccuracyDownsamplingIterator
extends DownsamplingIterator {
    private final Iterator<SAMRecord> underlyingIterator;
    private final Random random;
    private SAMRecord nextRecord;
    private final Map<String, Boolean> decisions = new HashMap<String, Boolean>();
    private double targetAccuracy = 1.0E-4;
    private long totalTemplates;
    private long keptTemplates;
    private Iterator<SAMRecord> bufferedRecords = new ArrayList().iterator();
    private Set<String> bufferedRecordsToKeep;

    @Override
    public boolean isHigherAccuracy() {
        return true;
    }

    HighAccuracyDownsamplingIterator(Iterator<SAMRecord> iterator, double d, int n) {
        super(d);
        this.underlyingIterator = iterator;
        this.random = new Random(n);
    }

    public DownsamplingIterator setTargetAccuracy(double d) {
        if (d >= 1.0 || d <= 4.656612875245797E-10) {
            throw new IllegalArgumentException("Illegal value. Must be 1/MAX_INT < accuracy < 1");
        }
        this.targetAccuracy = d;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null || this.advance();
    }

    @Override
    public SAMRecord next() {
        if (this.nextRecord == null) {
            throw new NoSuchElementException("Call to next() when hasNext() == false");
        }
        SAMRecord sAMRecord = this.nextRecord;
        this.advance();
        return sAMRecord;
    }

    protected Iterator<SAMRecord> getUnderlyingIterator() {
        return this.underlyingIterator;
    }

    protected boolean advance() {
        this.nextRecord = null;
        while (this.nextRecord == null && (this.bufferedRecords.hasNext() || this.bufferNextChunkOfRecords(this.getTargetProportion(), this.targetAccuracy))) {
            boolean bl;
            SAMRecord sAMRecord = this.bufferedRecords.next();
            String string = sAMRecord.getReadName();
            Boolean bl2 = this.decisions.get(string);
            if (bl2 == null) {
                bl = this.bufferedRecordsToKeep.contains(sAMRecord.getReadName());
                this.decisions.put(string, bl);
            } else {
                bl = bl2;
            }
            if (bl) {
                this.nextRecord = sAMRecord;
                this.recordAcceptedRecord();
                continue;
            }
            this.recordDiscardedRecord();
        }
        return this.nextRecord != null;
    }

    protected boolean bufferNextChunkOfRecords(double d, double d2) {
        int n = (int)Math.ceil(1.0 / d2);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<SAMRecord> arrayList = new ArrayList<SAMRecord>(n);
        this.readFromUnderlyingIterator(arrayList, hashSet, n);
        int n2 = hashSet.size();
        int n3 = this.calculateTemplatesToKeep(n2, d);
        int n4 = n2 - n3;
        ArrayList<String> arrayList2 = new ArrayList<String>(hashSet);
        Collections.shuffle(arrayList2, this.random);
        for (int i = 0; i < n4; ++i) {
            hashSet.remove(arrayList2.get(i));
        }
        this.bufferedRecordsToKeep = hashSet;
        this.bufferedRecords = arrayList.iterator();
        this.totalTemplates += (long)n2;
        this.keptTemplates += (long)hashSet.size();
        return !arrayList.isEmpty();
    }

    protected int calculateTemplatesToKeep(int n, double d) {
        double d2 = (double)n * d;
        return (double)this.keptTemplates / (double)this.totalTemplates < d ? (int)Math.ceil(d2) : (int)Math.floor(d2);
    }

    protected void readFromUnderlyingIterator(List<SAMRecord> list, Set<String> set, int n) {
        while (this.underlyingIterator.hasNext() && set.size() < n) {
            SAMRecord sAMRecord = this.underlyingIterator.next();
            list.add(sAMRecord);
            if (this.decisions.containsKey(sAMRecord.getReadName())) continue;
            set.add(sAMRecord.getReadName());
        }
    }
}

