/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.io.ExternalCompression;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import java.io.IOException;

public abstract class ExternalCompressor {
    private final BlockCompressionMethod method;

    private ExternalCompressor(BlockCompressionMethod blockCompressionMethod) {
        this.method = blockCompressionMethod;
    }

    public BlockCompressionMethod getMethod() {
        return this.method;
    }

    public abstract byte[] compress(byte[] var1);

    public static ExternalCompressor createRAW() {
        return new ExternalCompressor(BlockCompressionMethod.RAW){

            @Override
            public byte[] compress(byte[] byArray) {
                return byArray;
            }
        };
    }

    public static ExternalCompressor createGZIP() {
        return new ExternalCompressor(BlockCompressionMethod.GZIP){

            @Override
            public byte[] compress(byte[] byArray) {
                try {
                    return ExternalCompression.gzip(byArray);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    public static ExternalCompressor createLZMA() {
        return new ExternalCompressor(BlockCompressionMethod.LZMA){

            @Override
            public byte[] compress(byte[] byArray) {
                try {
                    return ExternalCompression.xz(byArray);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    public static ExternalCompressor createBZIP2() {
        return new ExternalCompressor(BlockCompressionMethod.BZIP2){

            @Override
            public byte[] compress(byte[] byArray) {
                try {
                    return ExternalCompression.bzip2(byArray);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    public static ExternalCompressor createRANS(final RANS.ORDER oRDER) {
        return new ExternalCompressor(BlockCompressionMethod.RANS){

            @Override
            public byte[] compress(byte[] byArray) {
                return ExternalCompression.rans(byArray, oRDER);
            }
        };
    }
}

