/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class GolombRiceIntegerCodec
extends AbstractBitCodec<Integer> {
    private final int m;
    private final int log2m;
    private final long mask;
    private boolean quotientBit = false;
    private int offset = 0;

    public GolombRiceIntegerCodec(int n, int n2) {
        this.log2m = n2;
        this.m = 1 << n2;
        this.quotientBit = true;
        this.offset = n;
        this.mask = ~(-1 << n2);
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n = 0;
        while (bitInputStream.readBit() == this.quotientBit) {
            ++n;
        }
        int n2 = bitInputStream.readBits(this.log2m);
        int n3 = n * this.m + n2;
        return n3 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        long l;
        long l2 = n + this.offset;
        long l3 = l2 >>> this.log2m;
        if (l3 > Integer.MAX_VALUE) {
            for (l = 0L; l < l3; ++l) {
                bitOutputStream.write(this.quotientBit);
            }
        } else if (l3 > 0L) {
            int n2 = (int)l3;
            for (int i = 0; i < n2; ++i) {
                bitOutputStream.write(this.quotientBit);
            }
        }
        bitOutputStream.write(!this.quotientBit);
        l = l2 & this.mask;
        long l4 = 1 << this.log2m - 1;
        for (int i = this.log2m - 1; i >= 0; --i) {
            long l5 = l & l4;
            bitOutputStream.write(l5 != 0L);
            l4 >>>= 1;
        }
        return l3 + 1L + (long)this.log2m;
    }

    @Override
    public final long numberOfBits(Integer n) {
        return (n + this.offset) / this.m + 1 + this.log2m;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

