/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import java.util.Arrays;

class ReferenceRegion {
    private final int index;
    private final String name;
    private long alignmentStart;
    private int arrayStart;
    private final byte[] array;

    public ReferenceRegion(byte[] byArray, int n, String string, long l, long l2) {
        this.array = byArray;
        this.index = n;
        this.name = string;
        if (l2 == -1L) {
            l2 = byArray.length;
        }
        if (l < 1L || l2 < l || l2 - l > (long)byArray.length || l2 - 1L > (long)byArray.length) {
            throw new IllegalArgumentException(String.format("Invalid reference region: %s, %d, %d.", string, l, l2));
        }
        this.alignmentStart = l;
        this.arrayStart = (int)(l - 1L);
    }

    int arrayPosition(long l) {
        int n = (int)((long)this.arrayStart + (l - this.alignmentStart));
        if (n < 0 || n > this.array.length) {
            throw new IllegalArgumentException("The alignment position is out of the region: " + l);
        }
        return n;
    }

    public byte base(long l) {
        return this.array[this.arrayPosition(l)];
    }

    public byte[] copy(long l, int n) {
        int n2 = this.arrayPosition(l);
        int n3 = this.arrayPosition(l + (long)n);
        return Arrays.copyOfRange(this.array, n2, n3);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public long getAlignmentStart() {
        return this.alignmentStart;
    }
}

