/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    private final Path path;
    protected SAMSequenceDictionary sequenceDictionary;

    AbstractFastaSequenceFile(File file) {
        this(file == null ? null : file.toPath());
    }

    AbstractFastaSequenceFile(Path path) {
        this.path = path;
        Path path2 = AbstractFastaSequenceFile.findSequenceDictionary(path);
        if (path2 != null) {
            IOUtil.assertFileIsReadable(path2);
            try {
                SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
                BufferedLineReader bufferedLineReader = new BufferedLineReader(Files.newInputStream(path2, new OpenOption[0]));
                SAMFileHeader sAMFileHeader = sAMTextHeaderCodec.decode(bufferedLineReader, path2.toString());
                if (sAMFileHeader.getSequenceDictionary() != null && !sAMFileHeader.getSequenceDictionary().isEmpty()) {
                    this.sequenceDictionary = sAMFileHeader.getSequenceDictionary();
                }
                bufferedLineReader.close();
            }
            catch (Exception exception) {
                throw new SAMException("Could not open sequence dictionary file: " + path2, exception);
            }
        }
    }

    protected static File findSequenceDictionary(File file) {
        if (file == null) {
            return null;
        }
        Path path = AbstractFastaSequenceFile.findSequenceDictionary(file.toPath());
        if (path == null) {
            return null;
        }
        return path.toFile();
    }

    protected static Path findSequenceDictionary(Path path) {
        if (path == null) {
            return null;
        }
        Path path2 = path.toAbsolutePath();
        Path path3 = path.toAbsolutePath();
        boolean bl = false;
        for (String string : ReferenceSequenceFileFactory.FASTA_EXTENSIONS) {
            String string2 = path2.getFileName().toString();
            if (!string2.endsWith(string)) continue;
            path3 = path2.resolveSibling(string2 + ".dict");
            String string3 = string2.substring(0, string2.lastIndexOf(string));
            path2 = path2.resolveSibling(string3 + ".dict");
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("File is not a supported reference file type: " + path.toAbsolutePath());
        }
        if (Files.exists(path2, new LinkOption[0])) {
            return path2;
        }
        if (Files.exists(path3, new LinkOption[0])) {
            return path3;
        }
        return null;
    }

    protected Path getPath() {
        return this.path;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected String getAbsolutePath() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String string, long l, long l2) {
        throw new UnsupportedOperationException("Index does not appear to exist for " + this.getAbsolutePath() + ".  samtools faidx can be used to create an index");
    }
}

