/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;

public class SRAAccession
implements Serializable {
    private static final Log log = Log.getInstance(SRAAccession.class);
    private static Boolean isSupportedCached = null;
    private static String appVersionString = null;
    private static final String defaultAppVersionString = "[unknown software]";
    private static final String htsJdkVersionString = "HTSJDK-NGS";
    private String acc;

    public static void setAppVersionString(String string) {
        appVersionString = string;
    }

    public static boolean isSupported() {
        if (isSupportedCached == null) {
            log.debug("Checking if SRA module is supported in that environment");
            isSupportedCached = NGS.isSupported();
            if (!isSupportedCached.booleanValue()) {
                log.info("SRA is not supported. Will not be able to read from SRA");
            } else {
                NGS.setAppVersionString((String)SRAAccession.getFullVersionString());
            }
        }
        return isSupportedCached;
    }

    public static boolean isValid(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.isFile()) {
            byte[] byArray = new byte[8];
            byte[] byArray2 = "NCBI.sra".getBytes();
            byte[] byArray3 = "NCBInenc".getBytes();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                int n = ((InputStream)fileInputStream).read(byArray);
                bl = n == byArray.length && (Arrays.equals(byArray, byArray2) || Arrays.equals(byArray, byArray3));
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = file.exists() ? false : string.toUpperCase().matches("^[SED]RR[0-9]{6,9}$");
        }
        if (!bl) {
            return false;
        }
        return SRAAccession.isSupported() && NGS.isValid((String)string);
    }

    public SRAAccession(String string) {
        this.acc = string;
    }

    public String toString() {
        return this.acc;
    }

    public boolean isValid() {
        return SRAAccession.isValid(this.acc);
    }

    private static String getFullVersionString() {
        String string = appVersionString == null ? defaultAppVersionString : appVersionString;
        string = string + " through HTSJDK-NGS";
        return string;
    }
}

