/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SRAIterator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.sra.SRALazyRecord;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReadIterator;

public class SRAUnalignmentIterator
implements Iterator<SAMRecord> {
    private ValidationStringency validationStringency;
    private SRAAccession accession;
    private ReadCollection run;
    private SAMFileHeader header;
    private SRAIterator.RecordRangeInfo recordRangeInfo;
    private ReadIterator unalignedIterator;
    private boolean hasMoreUnalignedReads = true;
    private Boolean hasMoreUnalignedFragments = false;
    private int lastUnalignedFragmentIndex;
    private SRALazyRecord lastRecord;

    public SRAUnalignmentIterator(SRAAccession sRAAccession, ReadCollection readCollection, SAMFileHeader sAMFileHeader, SRAIterator.RecordRangeInfo recordRangeInfo, Chunk chunk) {
        this.accession = sRAAccession;
        this.run = readCollection;
        this.header = sAMFileHeader;
        this.recordRangeInfo = recordRangeInfo;
        long l = chunk.getChunkStart() - recordRangeInfo.getTotalReferencesLength();
        if (l < 0L) {
            l = 0L;
        } else if (l >= recordRangeInfo.getNumberOfReads()) {
            throw new RuntimeException("Invalid chunk provided: chunkStart position is after last read");
        }
        long l2 = chunk.getChunkEnd() - recordRangeInfo.getTotalReferencesLength();
        if (l2 > recordRangeInfo.getNumberOfReads()) {
            l2 = recordRangeInfo.getNumberOfReads();
        } else if (l2 <= 0L) {
            throw new RuntimeException("Invalid chunk provided: chunkEnd position is before last read");
        }
        try {
            this.unalignedIterator = readCollection.getReadRange(l + 1L, l2 - l, 6);
            this.nextUnalignedFragment();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasMoreUnalignedFragments == null) {
            try {
                this.lastRecord.detachFromIterator();
                this.nextUnalignedFragment();
            }
            catch (ErrorMsg errorMsg) {
                throw new RuntimeException(errorMsg);
            }
        }
        return this.hasMoreUnalignedFragments;
    }

    @Override
    public SAMRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more alignments are available");
        }
        return this.nextUnalignment();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal of records not implemented.");
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    private SAMRecord nextUnalignment() {
        try {
            this.lastRecord = new SRALazyRecord(this.header, this.accession, this.run, this.unalignedIterator, this.unalignedIterator.getReadId(), this.lastUnalignedFragmentIndex);
        }
        catch (ErrorMsg errorMsg) {
            throw new RuntimeException(errorMsg);
        }
        if (this.validationStringency != null) {
            this.lastRecord.setValidationStringency(this.validationStringency);
        }
        this.hasMoreUnalignedFragments = null;
        return this.lastRecord;
    }

    private void nextUnalignedFragment() throws ErrorMsg {
        block4: {
            while (this.hasMoreUnalignedFragments == null || this.hasMoreUnalignedFragments.booleanValue()) {
                this.hasMoreUnalignedFragments = this.unalignedIterator.nextFragment();
                ++this.lastUnalignedFragmentIndex;
                if (!this.hasMoreUnalignedFragments.booleanValue() || this.unalignedIterator.isAligned()) continue;
                return;
            }
            if (!this.hasMoreUnalignedReads) {
                throw new RuntimeException("Cannot get next unaligned read - already at last one");
            }
            do {
                this.hasMoreUnalignedReads = this.unalignedIterator.nextRead();
                this.lastUnalignedFragmentIndex = -1;
                if (!this.hasMoreUnalignedReads) break block4;
                do {
                    this.hasMoreUnalignedFragments = this.unalignedIterator.nextFragment();
                    ++this.lastUnalignedFragmentIndex;
                } while (this.hasMoreUnalignedFragments.booleanValue() && this.unalignedIterator.isAligned());
            } while (!this.hasMoreUnalignedFragments.booleanValue());
            return;
        }
    }
}

