/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import java.util.ArrayList;
import java.util.List;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReferenceIterator;

public class SRAUtils {
    public static final int REFERENCE_ALIGNMENT = 5000;

    public static long getNumberOfReads(ReadCollection readCollection) throws ErrorMsg {
        return readCollection.getReadCount(7);
    }

    public static List<Long> getReferencesLengthsAligned(ReadCollection readCollection) throws ErrorMsg {
        ReferenceIterator referenceIterator = readCollection.getReferences();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (referenceIterator.nextReference()) {
            long l = referenceIterator.getLength();
            if (l % 5000L != 0L) {
                l += 5000L - l % 5000L;
            }
            arrayList.add(l);
        }
        return arrayList;
    }
}

