/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.io.Serializable;

public final class Murmur3
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int seed;

    public Murmur3(int n) {
        this.seed = n;
    }

    public int hashUnencodedChars(CharSequence charSequence) {
        int n;
        int n2 = this.seed;
        int n3 = charSequence.length();
        for (n = 1; n < n3; n += 2) {
            int n4 = charSequence.charAt(n - 1) | charSequence.charAt(n) << 16;
            n4 = Murmur3.mixK1(n4);
            n2 = Murmur3.mixH1(n2, n4);
        }
        if ((n3 & 1) == 1) {
            n = charSequence.charAt(n3 - 1);
            n = Murmur3.mixK1(n);
            n2 ^= n;
        }
        return Murmur3.fmix(n2, 2 * n3);
    }

    private int hashInt(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = Murmur3.mixK1(n);
        int n3 = Murmur3.mixH1(this.seed, n2);
        return Murmur3.fmix(n3, 4);
    }

    private int hashLong(long l) {
        if (l == 0L) {
            return 0;
        }
        int n = (int)l;
        int n2 = (int)(l >>> 32);
        int n3 = Murmur3.mixK1(n);
        int n4 = Murmur3.mixH1(this.seed, n3);
        n3 = Murmur3.mixK1(n2);
        n4 = Murmur3.mixH1(n4, n3);
        return Murmur3.fmix(n4, 8);
    }

    private static int mixK1(int n) {
        n *= -862048943;
        n = Integer.rotateLeft(n, 15);
        return n *= 461845907;
    }

    private static int mixH1(int n, int n2) {
        n ^= n2;
        n = Integer.rotateLeft(n, 13);
        n = n * 5 + -430675100;
        return n;
    }

    private static int fmix(int n, int n2) {
        n ^= n2;
        n ^= n >>> 16;
        n *= -2048144789;
        n ^= n >>> 13;
        n *= -1028477387;
        n ^= n >>> 16;
        return n;
    }
}

