/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.example;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.zip.DeflaterFactory;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PrintVariantsExample {
    private static final Log log = Log.getInstance(PrintVariantsExample.class);

    private PrintVariantsExample() {
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            System.out.println("Usage: " + PrintVariantsExample.class.getCanonicalName() + " inFile [outFile]");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = stringArray.length >= 2 ? new File(stringArray[1]) : null;
        long l = System.currentTimeMillis();
        log.info("Start with args:" + Arrays.toString(stringArray));
        PrintVariantsExample.printConfigurationInfo();
        try (VariantContextWriter variantContextWriter = file2 == null ? null : new VariantContextWriterBuilder().setOutputFile(file2).setOutputFileType(VariantContextWriterBuilder.OutputType.VCF).unsetOption(Options.INDEX_ON_THE_FLY).build();
             AbstractFeatureReader<VariantContext, LineIterator> abstractFeatureReader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), new VCFCodec(), false);){
            log.info(abstractFeatureReader.getClass().getSimpleName() + " hasIndex " + abstractFeatureReader.hasIndex());
            if (variantContextWriter != null) {
                log.info(variantContextWriter.getClass().getSimpleName());
                variantContextWriter.writeHeader((VCFHeader)abstractFeatureReader.getHeader());
            }
            ProgressLogger progressLogger = new ProgressLogger(log, 1000000);
            for (VariantContext variantContext : abstractFeatureReader.iterator()) {
                if (variantContextWriter != null) {
                    variantContextWriter.add(variantContext);
                }
                progressLogger.record(variantContext.getContig(), variantContext.getStart());
            }
        }
        long l2 = System.currentTimeMillis();
        log.info(String.format("Done. Elapsed time %.3f seconds", (double)(l2 - l) / 1000.0));
    }

    private static void printConfigurationInfo() throws IOException {
        log.info("Executing as " + System.getProperty("user.name") + '@' + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + ' ' + System.getProperty("java.runtime.version") + ' ' + (DeflaterFactory.usingIntelDeflater() ? "IntelDeflater" : "JdkDeflater"));
        log.info(Defaults.allDefaults().entrySet().stream().map(entry -> (String)entry.getKey() + ':' + entry.getValue()).collect(Collectors.joining(" ")));
    }
}

