/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.vcf.AbstractVCFCodec;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class VCFCodec
extends AbstractVCFCodec {
    public static final String VCF4_MAGIC_HEADER = "##fileformat=VCFv4";

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (lineIterator.hasNext()) {
            String string = lineIterator.peek();
            ++this.lineNo;
            if (string.startsWith("##")) {
                String[] stringArray = string.substring(2).split("=");
                if (stringArray.length == 2 && VCFHeaderVersion.isFormatString(stringArray[0])) {
                    if (!VCFHeaderVersion.isVersionString(stringArray[1])) {
                        throw new TribbleException.InvalidHeader(stringArray[1] + " is not a supported version");
                    }
                    bl = true;
                    this.version = VCFHeaderVersion.toHeaderVersion(stringArray[1]);
                    if (!this.version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_0)) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4; please use the VCF3 codec for " + stringArray[1]);
                    }
                    if (this.version != VCFHeaderVersion.VCF4_0 && this.version != VCFHeaderVersion.VCF4_1 && this.version != VCFHeaderVersion.VCF4_2) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4 and does not support " + stringArray[1]);
                    }
                }
                arrayList.add((String)lineIterator.next());
                continue;
            }
            if (string.startsWith("#")) {
                if (!bl) {
                    throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                }
                arrayList.add((String)lineIterator.next());
                super.parseHeaderFromLines(arrayList, this.version);
                return this.header;
            }
            throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected List<String> parseFilters(String string) {
        if (string.equals(".")) {
            return null;
        }
        if (string.equals("PASS")) {
            return Collections.emptyList();
        }
        if (string.equals("0")) {
            VCFCodec.generateException("0 is an invalid filter name in vcf4", this.lineNo);
        }
        if (string.isEmpty()) {
            VCFCodec.generateException("The VCF specification requires a valid filter status: filter was " + string, this.lineNo);
        }
        if (this.filterHash.containsKey(string)) {
            return (List)this.filterHash.get(string);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!string.contains(";")) {
            linkedList.add(string);
        } else {
            linkedList.addAll(Arrays.asList(string.split(";")));
        }
        this.filterHash.put(string, Collections.unmodifiableList(linkedList));
        return linkedList;
    }

    @Override
    public boolean canDecode(String string) {
        return VCFCodec.canDecodeFile(string, VCF4_MAGIC_HEADER);
    }
}

