/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class BAMIndexMetaData {
    private long noCoordinateRecords = 0L;
    private long firstOffset = -1L;
    private long lastOffset = 0L;
    private int alignedRecords = 0;
    private int unAlignedRecords = 0;

    BAMIndexMetaData() {
        this.newReference();
    }

    BAMIndexMetaData(List<Chunk> list) {
        if (list != null && !list.isEmpty() && list.size() != 2) {
            throw new SAMException("Unexpected number of metadata chunks " + list.size());
        }
        boolean bl = true;
        if (list != null) {
            for (Chunk chunk : list) {
                long l = chunk.getChunkStart();
                long l2 = chunk.getChunkEnd();
                if (bl) {
                    this.firstOffset = l;
                    this.lastOffset = l2;
                    bl = false;
                    continue;
                }
                bl = true;
                this.alignedRecords = (int)l;
                this.unAlignedRecords = (int)l2;
            }
        }
    }

    public int getAlignedRecordCount() {
        return this.alignedRecords;
    }

    public int getUnalignedRecordCount() {
        return this.unAlignedRecords;
    }

    void newReference() {
        this.firstOffset = -1L;
        this.lastOffset = 0L;
        this.alignedRecords = 0;
        this.unAlignedRecords = 0;
    }

    void recordMetaData(SAMRecord sAMRecord) {
        int n = sAMRecord.getAlignmentStart();
        if (n == 0) {
            this.incrementNoCoordinateRecordCount();
            return;
        }
        if (sAMRecord.getFileSource() == null) {
            throw new SAMException("BAM cannot be indexed without setting a fileSource for record " + sAMRecord);
        }
        Chunk chunk = ((BAMFileSpan)sAMRecord.getFileSource().getFilePointer()).getSingleChunk();
        long l = chunk.getChunkStart();
        long l2 = chunk.getChunkEnd();
        if (sAMRecord.getReadUnmappedFlag()) {
            ++this.unAlignedRecords;
        } else {
            ++this.alignedRecords;
        }
        if (BlockCompressedFilePointerUtil.compare(l, this.firstOffset) < 1 || this.firstOffset == -1L) {
            this.firstOffset = l;
        }
        if (BlockCompressedFilePointerUtil.compare(this.lastOffset, l2) < 1) {
            this.lastOffset = l2;
        }
    }

    void recordMetaData(Slice slice) {
        int n = slice.alignmentStart;
        if (n == 0) {
            this.noCoordinateRecords += (long)slice.nofRecords;
            return;
        }
        long l = slice.offset;
        long l2 = slice.offset + 0;
        if (slice.alignmentSpan < 1) {
            this.unAlignedRecords += slice.nofRecords;
        } else {
            this.alignedRecords += slice.nofRecords;
        }
        if (BlockCompressedFilePointerUtil.compare(l, this.firstOffset) < 1 || this.firstOffset == -1L) {
            this.firstOffset = l;
        }
        if (BlockCompressedFilePointerUtil.compare(this.lastOffset, l2) < 1) {
            this.lastOffset = l2;
        }
    }

    void incrementNoCoordinateRecordCount() {
        ++this.noCoordinateRecords;
    }

    private void setNoCoordinateRecordCount(long l) {
        this.noCoordinateRecords = l;
    }

    long getNoCoordinateRecordCount() {
        return this.noCoordinateRecords;
    }

    long getFirstOffset() {
        return this.firstOffset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    public static void printIndexStats(File file) {
        try {
            BAMFileReader bAMFileReader = new BAMFileReader(file, null, false, ValidationStringency.SILENT, (SAMRecordFactory)new DefaultSAMRecordFactory());
            if (!bAMFileReader.hasIndex()) {
                throw new SAMException("No index for bam file " + file);
            }
            BAMIndexMetaData[] bAMIndexMetaDataArray = BAMIndexMetaData.getIndexStats(bAMFileReader);
            int n = bAMFileReader.getFileHeader().getSequenceDictionary().size();
            for (int i = 0; i < n; ++i) {
                SAMSequenceRecord sAMSequenceRecord = bAMFileReader.getFileHeader().getSequence(i);
                if (sAMSequenceRecord == null) continue;
                String string = sAMSequenceRecord.getSequenceName();
                int n2 = sAMSequenceRecord.getSequenceLength();
                System.out.print(string + ' ' + "length=\t" + n2);
                if (bAMIndexMetaDataArray[i] == null) {
                    System.out.println();
                    continue;
                }
                System.out.println("\tAligned= " + bAMIndexMetaDataArray[i].getAlignedRecordCount() + "\tUnaligned= " + bAMIndexMetaDataArray[i].getUnalignedRecordCount());
            }
            System.out.println("NoCoordinateCount= " + bAMIndexMetaDataArray[0].getNoCoordinateRecordCount());
        }
        catch (IOException iOException) {
            throw new SAMException("Exception in getting index statistics", iOException);
        }
    }

    public static BAMIndexMetaData[] getIndexStats(BAMFileReader bAMFileReader) {
        Long l;
        AbstractBAMFileIndex abstractBAMFileIndex = (AbstractBAMFileIndex)bAMFileReader.getIndex();
        int n = abstractBAMFileIndex.getNumberOfReferences();
        BAMIndexMetaData[] bAMIndexMetaDataArray = new BAMIndexMetaData[n == 0 ? 1 : n];
        for (int i = 0; i < n; ++i) {
            bAMIndexMetaDataArray[i] = abstractBAMFileIndex.getMetaData(i);
        }
        if (bAMIndexMetaDataArray[0] == null) {
            bAMIndexMetaDataArray[0] = new BAMIndexMetaData();
        }
        if ((l = abstractBAMFileIndex.getNoCoordinateCount()) != null) {
            bAMIndexMetaDataArray[0].setNoCoordinateRecordCount(l);
        }
        return bAMIndexMetaDataArray;
    }
}

