/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringLineReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private CRAMContainerStreamWriter cramContainerStream;
    private final SAMFileHeader samFileHeader;
    private final String fileName;
    private static final Log log = Log.getInstance(CRAMFileWriter.class);

    public CRAMFileWriter(OutputStream outputStream, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        this(outputStream, null, referenceSource, sAMFileHeader, string);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream outputStream2, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        this(outputStream, outputStream2, true, referenceSource, sAMFileHeader, string);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream outputStream2, boolean bl, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        if (outputStream == null) {
            throw new IllegalArgumentException("CRAMWriter output stream can not be null.");
        }
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required for CRAM writers");
        }
        if (sAMFileHeader == null) {
            throw new IllegalArgumentException("A valid SAMFileHeader is required for CRAM writers");
        }
        this.samFileHeader = sAMFileHeader;
        this.fileName = string;
        this.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        this.cramContainerStream = new CRAMContainerStreamWriter(outputStream, outputStream2, referenceSource, sAMFileHeader, string);
        this.setHeader(sAMFileHeader);
    }

    @Override
    protected void writeAlignment(SAMRecord sAMRecord) {
        this.cramContainerStream.writeAlignment(sAMRecord);
    }

    @Override
    protected void writeHeader(String string) {
        this.cramContainerStream.writeHeader(new SAMTextHeaderCodec().decode(new StringLineReader(string), this.fileName != null ? this.fileName : null));
    }

    @Override
    protected void finish() {
        this.cramContainerStream.finish(true);
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }

    public boolean isPreserveReadNames() {
        return this.cramContainerStream.isPreserveReadNames();
    }

    public void setPreserveReadNames(boolean bl) {
        this.cramContainerStream.setPreserveReadNames(bl);
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        return this.cramContainerStream.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.cramContainerStream.isCaptureAllTags();
    }

    public void setCaptureAllTags(boolean bl) {
        this.cramContainerStream.setCaptureAllTags(bl);
    }

    public Set<String> getCaptureTags() {
        return this.cramContainerStream.getCaptureTags();
    }

    public void setCaptureTags(Set<String> set) {
        this.cramContainerStream.setCaptureTags(set);
    }

    public Set<String> getIgnoreTags() {
        return this.cramContainerStream.getIgnoreTags();
    }

    public void setIgnoreTags(Set<String> set) {
        this.cramContainerStream.setIgnoreTags(set);
    }
}

