/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Cigar
implements Serializable,
Iterable<CigarElement> {
    public static final long serialVersionUID = 1L;
    private final List<CigarElement> cigarElements = new ArrayList<CigarElement>();

    public Cigar() {
    }

    public Cigar(List<CigarElement> list) {
        this.cigarElements.addAll(list);
    }

    public List<CigarElement> getCigarElements() {
        return Collections.unmodifiableList(this.cigarElements);
    }

    public CigarElement getCigarElement(int n) {
        return this.cigarElements.get(n);
    }

    public void add(CigarElement cigarElement) {
        this.cigarElements.add(cigarElement);
    }

    public int numCigarElements() {
        return this.cigarElements.size();
    }

    public boolean isEmpty() {
        return this.cigarElements.isEmpty();
    }

    public int getReferenceLength() {
        int n = 0;
        for (CigarElement cigarElement : this.cigarElements) {
            switch (cigarElement.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: {
                    n += cigarElement.getLength();
                    break;
                }
            }
        }
        return n;
    }

    public int getPaddedReferenceLength() {
        int n = 0;
        for (CigarElement cigarElement : this.cigarElements) {
            switch (cigarElement.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: 
                case P: {
                    n += cigarElement.getLength();
                    break;
                }
            }
        }
        return n;
    }

    public int getReadLength() {
        return Cigar.getReadLength(this.cigarElements);
    }

    public static int getReadLength(List<CigarElement> list) {
        int n = 0;
        for (CigarElement cigarElement : list) {
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            n += cigarElement.getLength();
        }
        return n;
    }

    public List<SAMValidationError> isValid(String string, long l) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<SAMValidationError> arrayList = null;
        boolean bl = false;
        for (int i = 0; i < this.cigarElements.size(); ++i) {
            CigarOperator cigarOperator;
            CigarElement cigarElement = this.cigarElements.get(i);
            if (cigarElement.getLength() == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "CIGAR element with zero length", string, l));
            }
            if (Cigar.isClippingOperator(cigarOperator = cigarElement.getOperator())) {
                if (cigarOperator == CigarOperator.H) {
                    if (i == 0 || i == this.cigarElements.size() - 1) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Hard clipping operator not at start or end of CIGAR", string, l));
                    continue;
                }
                if (cigarOperator != CigarOperator.S) {
                    throw new IllegalStateException("Should never happen: " + cigarOperator.name());
                }
                if (i == 0 || i == this.cigarElements.size() - 1) continue;
                if (i == 1) {
                    if (this.cigarElements.size() == 3 && this.cigarElements.get(2).getOperator() == CigarOperator.H || this.cigarElements.get(0).getOperator() == CigarOperator.H) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can only be inside of hard clipping operator", string, l));
                    continue;
                }
                if (i == this.cigarElements.size() - 2) {
                    if (this.cigarElements.get(this.cigarElements.size() - 1).getOperator() == CigarOperator.H) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can only be inside of hard clipping operator", string, l));
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can at start or end of read, or be inside of hard clipping operator", string, l));
                continue;
            }
            if (Cigar.isRealOperator(cigarOperator)) {
                CigarOperator cigarOperator2;
                bl = true;
                if (!Cigar.isInDelOperator(cigarOperator)) continue;
                for (int j = i + 1; !(j >= this.cigarElements.size() || Cigar.isRealOperator(cigarOperator2 = this.cigarElements.get(j).getOperator()) && !Cigar.isInDelOperator(cigarOperator2) || Cigar.isPaddingOperator(cigarOperator2)); ++j) {
                    if (!Cigar.isInDelOperator(cigarOperator2) || cigarOperator != cigarOperator2) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new SAMValidationError(SAMValidationError.Type.ADJACENT_INDEL_IN_CIGAR, "No M or N operator between pair of " + cigarOperator.name() + " operators in CIGAR", string, l));
                }
                continue;
            }
            if (!Cigar.isPaddingOperator(cigarOperator) || i == 0) continue;
            if (i == this.cigarElements.size() - 1) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not valid at end of CIGAR", string, l));
                continue;
            }
            if (Cigar.isRealOperator(this.cigarElements.get(i - 1).getOperator()) && Cigar.isRealOperator(this.cigarElements.get(i + 1).getOperator())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not between real operators in CIGAR", string, l));
        }
        if (!bl) {
            if (arrayList == null) {
                arrayList = new ArrayList<SAMValidationError>();
            }
            arrayList.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "No real operator (M|I|D|N) in CIGAR", string, l));
        }
        return arrayList;
    }

    private static boolean isRealOperator(CigarOperator cigarOperator) {
        return cigarOperator == CigarOperator.M || cigarOperator == CigarOperator.EQ || cigarOperator == CigarOperator.X || cigarOperator == CigarOperator.I || cigarOperator == CigarOperator.D || cigarOperator == CigarOperator.N;
    }

    private static boolean isInDelOperator(CigarOperator cigarOperator) {
        return cigarOperator != null && cigarOperator.isIndel();
    }

    private static boolean isClippingOperator(CigarOperator cigarOperator) {
        return cigarOperator != null && cigarOperator.isClipping();
    }

    private static boolean isPaddingOperator(CigarOperator cigarOperator) {
        return cigarOperator != null && cigarOperator.isPadding();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cigar)) {
            return false;
        }
        Cigar cigar = (Cigar)object;
        return this.cigarElements.equals(cigar.cigarElements);
    }

    public static Cigar fromCigarOperators(List<CigarOperator> list) {
        if (list == null) {
            throw new IllegalArgumentException("cigarOperators is null");
        }
        ArrayList<CigarElement> arrayList = new ArrayList<CigarElement>();
        int n = 0;
        while (n < list.size()) {
            int n2;
            CigarOperator cigarOperator = list.get(n);
            for (n2 = n + 1; n2 < list.size() && list.get(n2).equals((Object)cigarOperator); ++n2) {
            }
            arrayList.add(new CigarElement(n2 - n, cigarOperator));
            n = n2;
        }
        return new Cigar(arrayList);
    }

    @Override
    public Iterator<CigarElement> iterator() {
        return this.getCigarElements().iterator();
    }

    public boolean containsOperator(CigarOperator cigarOperator) {
        return this.cigarElements.stream().anyMatch(cigarElement -> cigarElement.getOperator() == cigarOperator);
    }

    public CigarElement getFirstCigarElement() {
        return this.isEmpty() ? null : this.cigarElements.get(0);
    }

    public CigarElement getLastCigarElement() {
        return this.isEmpty() ? null : this.cigarElements.get(this.numCigarElements() - 1);
    }

    public boolean isLeftClipped() {
        return !this.isEmpty() && Cigar.isClippingOperator(this.getFirstCigarElement().getOperator());
    }

    public boolean isRightClipped() {
        return !this.isEmpty() && Cigar.isClippingOperator(this.getLastCigarElement().getOperator());
    }

    public boolean isClipped() {
        return this.isLeftClipped() || this.isRightClipped();
    }

    public int hashCode() {
        return this.cigarElements.hashCode();
    }

    public String toString() {
        return TextCigarCodec.encode(this);
    }
}

