/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.Log;
import java.net.URL;
import java.net.URLClassLoader;

public class CustomReaderFactory {
    private static final Log LOG = Log.getInstance(CustomReaderFactory.class);
    private static final CustomReaderFactory DEFAULT_FACTORY;
    private static CustomReaderFactory currentFactory;
    private String urlPrefix = "";
    private String factoryClassName = "";
    private String jarFile = "";
    private ICustomReaderFactory factory;

    public static void setInstance(CustomReaderFactory customReaderFactory) {
        currentFactory = customReaderFactory;
    }

    public static void resetToDefaultInstance() {
        CustomReaderFactory.setInstance(DEFAULT_FACTORY);
    }

    public static CustomReaderFactory getInstance() {
        return currentFactory;
    }

    private CustomReaderFactory() {
        this(Defaults.CUSTOM_READER_FACTORY);
    }

    CustomReaderFactory(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            return;
        }
        this.urlPrefix = stringArray[0].toLowerCase();
        this.factoryClassName = stringArray[1];
        if (stringArray.length > 2) {
            this.jarFile = stringArray[2];
        }
    }

    private synchronized ICustomReaderFactory getFactory() {
        if (this.factory == null) {
            try {
                Class<?> clazz = null;
                if (!this.jarFile.isEmpty()) {
                    LOG.info("Attempting to load factory class " + this.factoryClassName + " from " + this.jarFile);
                    URL uRL = new URL("file:///" + this.jarFile);
                    clazz = Class.forName(this.factoryClassName, true, new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader()));
                } else {
                    LOG.info("Attempting to load factory class " + this.factoryClassName);
                    clazz = Class.forName(this.factoryClassName);
                }
                this.factory = (ICustomReaderFactory)clazz.newInstance();
                LOG.info("Created custom factory for " + this.urlPrefix + " from " + this.factoryClassName + " loaded from " + (this.jarFile.isEmpty() ? " this jar" : this.jarFile));
            }
            catch (Exception exception) {
                LOG.error(exception, new Object[0]);
                return null;
            }
        }
        return this.factory;
    }

    public SamReader maybeOpen(URL uRL) {
        if (this.urlPrefix.isEmpty() || !uRL.toString().toLowerCase().startsWith(this.urlPrefix)) {
            return null;
        }
        LOG.info("Attempting to open " + uRL + " with custom factory");
        ICustomReaderFactory iCustomReaderFactory = this.getFactory();
        if (iCustomReaderFactory == null) {
            return null;
        }
        return iCustomReaderFactory.open(uRL);
    }

    static {
        currentFactory = DEFAULT_FACTORY = new CustomReaderFactory();
    }

    public static interface ICustomReaderFactory {
        public SamReader open(URL var1);
    }
}

